## Properties

Returns the value of the specified property of the member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
| |TYPED |one | |



### Return

```
value
```



### Description

Returns the value (as a string) of the specified property of the member.

The 'TYPED' flag indicates the value should be returned using its native type instead of as a string. E.g. numeric values will be returned for numeric properties.

The function can be used either for intrinsic or user-defined properties.

Since version 8.2 parent properties are also accessible from the children.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Properties('MEMBER_NAME')

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the property as a string. Note that property names are not case sensitive.

In our example, returns the name of the member.

**Query**

```
WITH
    MEMBER [Measures].[PARIS_NAME] AS [Geography].[Geo].[Paris].Properties('MEMBER_NAME')
SELECT
    [Measures].[PARIS_NAME] On 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">PARIS_NAME</td>
</tr>
<tr>
 <td>Paris</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[PARIS_NAME] AS "Paris"
SELECT
    [Measures].[PARIS_NAME] On 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[PARIS_NAME] AS [Geography].[Geo].[Paris].getProperty('MEMBER_NAME')
SELECT
    [Measures].[PARIS_NAME] On 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Properties('Level_Number',TYPED)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the 'typed' version of the property.

In our example, the level number as an integer value.

**Query**

```
WITH
    MEMBER [Measures].[INT_VALUE] AS [Geography].[Geo].[Paris].Properties( "Level_Number", TYPED)
    MEMBER [Measures].[STR_VALUE] AS [Geography].[Geo].[Paris].Properties( "Level_Number" )
SELECT
    {[Measures].[INT_VALUE],[Measures].[STR_VALUE]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">INT_VALUE</td>
  <td class="ic3-mdx-result-cell-header">STR_VALUE</td>
</tr>
<tr>
 <td>3</td>
 <td>3</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[INT_VALUE] AS 3
    MEMBER [Measures].[STR_VALUE] AS "3"
SELECT
    { [Measures].[INT_VALUE], [Measures].[STR_VALUE] } ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Properties('MISSING PROPERTY') - not existing property

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if the property does not exist.

**Query**

```
WITH
    MEMBER [Measures].[isError] AS isError( [Geography].[Geo].[Paris].Properties( "MISSING PROPERTY" ) )
SELECT
    { [Measures].[isError] } ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isError</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isError] AS TRUE
SELECT
    { [Measures].[isError] } ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Properties('CUSTOM_ROLLUP') - NULL property

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty string if the property is NULL.

**Query**

```
WITH
    MEMBER [Measures].[IsEmptyString] AS ""  =  ( [Geography].[Geo].[Paris].Properties( "CUSTOM_ROLLUP" ) )
SELECT
    {[Measures].[IsEmptyString]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IsEmptyString</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IsEmptyString] AS TRUE
SELECT
    { [Measures].[IsEmptyString] } ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Properties('CUSTOM_ROLLUP',TYPED) - NULL property

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the property is NULL and the 'TYPED' option is used.

**Query**

```
WITH
    MEMBER [Measures].[isEmpty] AS isEmpty( [Geography].[Geo].[Paris].Properties( "CUSTOM_ROLLUP", TYPED) )
SELECT
    {[Measures].[isEmpty]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isEmpty</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isEmpty] AS TRUE
SELECT
    { [Measures].[isEmpty] } ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Properties(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[MISSING_PROPERTY] AS [Measures].[Amount].Properties("hello")
SELECT
    [Measures].[MISSING_PROPERTY] On 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">MISSING_PROPERTY</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_PROPERTY_NOT_FOUND)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_PROPERTY_NOT_FOUND](icCubeError.md#olap_property_not_found)<br>Error Message : Properties() : the property 'hello' was not found for level '[Measures]'</pre>


 
</div>

                                                                         

### See Also


[GetProperty](GetProperty.md)

[GetPropertyUniqueValues](GetPropertyUniqueValues.md)

[Dimension Properties](Dimension%20Properties.md)

[Member Custom Property](Member%20Custom%20Property.md)

[Member Attributes](Member%20Attributes.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
