## Prod

Returns the product of all values of the specified set expression.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|value |numeric-expression |one | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
value
```



### Description

Returns the product of all values of the specified set, evaluated using 'value-expression'.

The Prod function will return a double numeric value if the value-expression is an integer value. if an evaluated
value is Zero it will stop iterating an return this zero value.

EXCLUDEEMPTY, will ignore NULL values. INCLUDEEMPTY, will convert NULL value to Zero (if a non value exists).

If no numeric expression is specified, the current members context will be used to evaluate the tuples.



### Since Version

6.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Prod(tuple-set, Numeric_Expression)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the product of the tuples set evaluating the numeric expression.

In our example, for each member of the set we multiply by 2.

**Query**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Prod( {[Geography].[Geo].[America],[Geography].[Geo].[America]}, 2.0 )
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td>4.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS 2.0 * 2.0
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Prod(tuple-set, Numeric_Expression) - empty value

</div>

<div class="ic3-mdx-example-body" style="display:none">

Unless all values are empty, the Prod function will return zero if an empty value is evaluated and
the INCLUDEEMPTY is active.

**Query**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Prod( [Geography].[Geo].[City], [Measures].[Amount] )
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td>0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS 0
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Prod( [Geography].[Geo].[City], [Measures].[Amount], INCLUDEEMPTY )
SELECT
    [Measures].[Sum Amount] ON 0
FROM
   [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Prod(tuple-set, Numeric_Expression, EXCLUDEEMPTY)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the product of the tuples set evaluating the numeric expression, excluding empty values.

**Query**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Prod( {[Geography].[Geo].[America],[Geography].[Geo].[America]}, [Amount], EXCLUDEEMPTY )
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td>589824.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Vector( {[Geography].[Geo].[America],[Geography].[Geo].[America]}, [Amount], EXCLUDEEMPTY )->product()
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Prod(tuple-set, Numeric_Expression) - all values are empty

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns empty if all values are empty

**Query**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Prod( [Geography].[Geo].[City], NULL )
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS NULL
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Prod( [Geography].[Geo].[City], NULL, EXCLUDEEMPTY )
SELECT
    [Measures].[Sum Amount] ON 0
FROM
   [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Prod(NULL),Prod({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity or an empty set.

**Query**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Prod(NULL)
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Prod({})
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS null
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Avg](Avg.md)

[Min](Min.md)

[Median](Median.md)

[Max](Max.md)

[Sum](Sum.md)

[Vector](Vector.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
