## PeriodsToDate

Returns the set of members starting from the first sibling of the specified member and ending with the specified member itself.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |level-expression |zero-one | |
| |member-expression |zero-one | |



### Return

```
set
```



### Description

This function returns a set starting at the first sibling, at specified level, and ending at the member itself.

The both parameters are optional:
1) If the member expression is missing, then the level-hierarchy.CurrentMember will be used.
2) If level-expression is missing, the parent level of the [Time].CurrentMember in the default time dimension of the cube will be used.

It is equivalent to { OpeningPeriod( member.level, Ancestor(member,level) ) : member }; note the range operator.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### PeriodsToDate(level,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Getting all the months of the 2010 year starting with the first month [Jan 2010] and ending with the specified member: [Jun 2010].

**Query**

```
PeriodsToDate([Time].[Calendar].[Year],[Jun 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2010], 
  [Time].[Calendar].[Month].[Feb 2010], 
  [Time].[Calendar].[Month].[Mar 2010], 
  [Time].[Calendar].[Month].[Apr 2010], 
  [Time].[Calendar].[Month].[May 2010], 
  [Time].[Calendar].[Month].[Jun 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Jan 2010] : [Jun 2010]}
```


**Assertion : MDX Equals**

```
{ OpeningPeriod( [Jun 2010].level, Ancestor([Jun 2010],[Time].[Calendar].[Year]) ) : [Jun 2010] }
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### PeriodsToDate(level,member) - non time dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

PeriodsToDate can also be used with non-time dimensions.

**Query**

```
PeriodsToDate([Geography].[Geo].[Country],[Geography].[Geo].[Mexico])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Mexico]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ OpeningPeriod( [Geography].[Geo].[Mexico].level, Ancestor([Geography].[Geo].[Mexico],[Geography].[Geo].[Country]) ) : [Geography].[Geo].[Mexico] }
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### PeriodsToDate(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If no member is specified then [Time].CurrentMember is used instead.

**Query**

```
WITH
    MEMBER period_names AS GENERATE( PeriodsToDate( [Time].[Calendar].[Year] ) as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Aug 2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">period_names</td>
</tr>
<tr>
 <td>Jan 2010-Feb 2010-Mar 2010-Apr 2010-May 2010-Jun 2010-Jul 2010-Aug 2010</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER period_names AS GENERATE( PeriodsToDate( [Time].[Calendar].[Year], [Time].[Calendar].currentMember ) as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Aug 2010]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### PeriodsToDate()

</div>

<div class="ic3-mdx-example-body" style="display:none">

If both the level and the member are not specified, then [Time].currentMember is used as the
member expression and its parent level as the level expression.

**Query**

```
WITH
    MEMBER period_names AS GENERATE( PeriodsToDate() as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Aug 2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">period_names</td>
</tr>
<tr>
 <td>Jul 2010-Aug 2010</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER period_names AS GENERATE( PeriodsToDate( [Time].[Calendar].CurrentMember.Parent.Level, [Time].[Calendar].CurrentMember ) as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Aug 2010]
```


 
</div>

                                                                                                            

### See Also


[OpeningPeriod](OpeningPeriod.md)

[Ancestor](Ancestor.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
