## Order

Orders members in a set optionally keeping their natural order (i.e., hierarchical order).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|number |numeric-expression |zero-one | |
|option |ASC-DESC-BASC-BDESC |zero-one |ASC |
|option |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
set
```



### Description

The function performs a rearrangement of the specified set. It is possible to break the hierarchy ordering during members arrangement using additional flag option.

1) If BASC or BDESC is specified: members are ordered regardless of their natural position. Parent/child relations are broken.

2) If ASC or DESC flag is specified: only sibling members (children of the same parent) are ordered. So, parent/child relations are kept in the resulting set.

The ASC flag is the default option.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(set,numeric,BASC)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the members in ascending order using the numeric expression.

Note how member original order is kept for members with the same value

**Query**

```
WITH
    MEMBER  [Geography].[Geo].[First]  AS 1.0
    MEMBER  [Geography].[Geo].[Second] AS 2.0
    MEMBER  [Geography].[Geo].[Third]  AS 2.0
SELECT
    Order({[Geography].[Geo].[Second], [Geography].[Geo].[First], [Geography].[Geo].[Third]}, [Measures].[Amount], BASC) on 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">First</td>
  <td class="ic3-mdx-result-cell-header">Second</td>
  <td class="ic3-mdx-result-cell-header">Third</td>
</tr>
<tr>
 <td>1.0</td>
 <td>2.0</td>
 <td>2.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER  [Geography].[Geo].[First] AS 1.0
    MEMBER  [Geography].[Geo].[Second] AS 2.0
    MEMBER  [Geography].[Geo].[Third]  AS 2.0
SELECT
    {[Geography].[Geo].[First], [Geography].[Geo].[Second],[Geography].[Geo].[Third]}  on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(set,numeric,BDESC)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the members in descending order using the numeric expression.

Note how member original order is kept for members with the same value

**Query**

```
WITH
    MEMBER  [Geography].[Geo].[First] AS 1.0
    MEMBER  [Geography].[Geo].[Second] AS 2.0
    MEMBER  [Geography].[Geo].[Third]  AS 2.0
SELECT
    Order({[Geography].[Geo].[Second],[Geography].[Geo].[First], [Geography].[Geo].[Third]}, [Measures].[Amount], BDESC) on 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Second</td>
  <td class="ic3-mdx-result-cell-header">Third</td>
  <td class="ic3-mdx-result-cell-header">First</td>
</tr>
<tr>
 <td>2.0</td>
 <td>2.0</td>
 <td>1.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER  [Geography].[Geo].[First] AS 1.0
    MEMBER  [Geography].[Geo].[Second] AS 2.0
    MEMBER  [Geography].[Geo].[Third]  AS 2.0
SELECT
    {[Geography].[Geo].[Second], [Geography].[Geo].[Third],[Geography].[Geo].[First]}  on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(set,string,BASC)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Set may be ordered according to string expressions instead of numerical ones.

**Query**

```
WITH
    MEMBER  [Geography].[Geo].[First] AS 4.0
    MEMBER  [Geography].[Geo].[Second] AS 1.0
    MEMBER  [Geography].[Geo].[Third]  AS 3.0
SELECT
    Order({[Geography].[Geo].[Second],[Geography].[Geo].[First], [Geography].[Geo].[Third]}, [Geography].[Geo].currentMember.name, BASC) on 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">First</td>
  <td class="ic3-mdx-result-cell-header">Second</td>
  <td class="ic3-mdx-result-cell-header">Third</td>
</tr>
<tr>
 <td>4.0</td>
 <td>1.0</td>
 <td>3.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER  [Geography].[Geo].[First] AS 4.0
    MEMBER  [Geography].[Geo].[Second] AS 1.0
    MEMBER  [Geography].[Geo].[Third]  AS 3.0
SELECT
    {[Geography].[Geo].[First], [Geography].[Geo].[Second],[Geography].[Geo].[Third]}  on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(set,string,ASC)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the members using their natural order (hierarchize) where siblings are sorted using the ASC/DESC flag.

In our example, we're sorting by name. First we sort the cities by country (we would be sorting by continent if they had different ones); afterwards we sort the cities belonging to the same parent by name. That is the reason we got first all cities of France.

Check how the same behaviour may be produced using the Generate() function in the test.

**Query**

```
WITH
    SET [Europe-Cities]  AS Descendants( [Geography].[Geo].[Europe], [Geography].[Geo].[City] )
SELECT
    Order( [Europe-Cities] , [Geography].[Geo].currentMember.name, ASC) on 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Geneva</td>
  <td class="ic3-mdx-result-cell-header">Lausanne</td>
  <td class="ic3-mdx-result-cell-header">Zurich</td>
</tr>
<tr>
 <td>4</td>
 <td>2</td>
 <td>1</td>
 <td></td>
 <td>128</td>
 <td>56</td>
 <td>64</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    SET [Ordered European cities] AS Order( [Geography].[Geo].[Europe].children, [Geography].[Geo].currentMember.name, ASC)
SELECT
    Generate(  [Ordered European cities],
            Order( [Geography].[Geo].currentMember.children, [Geography].[Geo].currentMember.name, ASC ) ) on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(set,string,BASC, EXCLUDEEMPTY)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Adding the EXCLUDEEMPTY option filters out the null values from the result

**Query**

```
WITH
    MEMBER  [Geography].[Geo].[First] AS 4.0
    MEMBER  [Geography].[Geo].[Second] AS NULL
    MEMBER  [Geography].[Geo].[Third]  AS 3.0
SELECT
    Order({[Geography].[Geo].[Second],[Geography].[Geo].[First], [Geography].[Geo].[Third]}, [Measures].[Amount], BDESC, EXCLUDEEMPTY) on 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">First</td>
  <td class="ic3-mdx-result-cell-header">Third</td>
</tr>
<tr>
 <td>4.0</td>
 <td>3.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER  [Geography].[Geo].[First] AS 4.0
    MEMBER  [Geography].[Geo].[Third]  AS 3.0
SELECT
    {[Geography].[Geo].[First], [Geography].[Geo].[Third]}  on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(set,string,ASC) - no siblings / hierarchize

</div>

<div class="ic3-mdx-example-body" style="display:none">

Order using ASC on a set without siblings gives the same result as calling the Hierarchize() function.

**Query**

```
WITH
    SET [Broken Hierarchy] AS {[Geography].[Geo].[Lausanne],[Geography].[Geo].[Mexico],[Geography].[Geo].[Continent].[America]}
SELECT
    --ORDER( [Broken Hierarchy], [Broken Hierarchy].currentMember.NAME, ASC ) on 0
    ORDER( [Broken Hierarchy], [Geography].[Geo].currentMember.NAME, ASC ) on 0
FROM
    [sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">America</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">Lausanne</td>
</tr>
<tr>
 <td>768</td>
 <td></td>
 <td>56</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    SET [Broken Hierarchy] AS {[Geography].[Geo].[Lausanne],[Geography].[Geo].[Mexico],[Geography].[Geo].[Continent].[America]}
SELECT
    Hierarchize( [Broken Hierarchy] ) on 0
FROM
    [sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(set,numeric,DESC)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the set hierarchized with the siblings ordered using the numeric expression.

In our example, sorting the countries is the same as sorting the whole hierarchy and filtering the countries from the result.

**Query**

```
SELECT
    Order( [Geography].[Geo].[Country].members, [Measures].[Amount], DESC) on 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
</tr>
<tr>
 <td>768</td>
 <td></td>
 <td></td>
 <td></td>
 <td>248</td>
 <td>4</td>
 <td>3</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    SET [AllMembers] AS Order( [Geography].[Geo].members, [Measures].[Amount], DESC)
SELECT
    Filter( [AllMembers] as s1, s1.currentMember.level IS [Geography].[Geo].[Country]) on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(tuple-set,numeric,DESC) - sorting tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

Tuples set are ordered in a different way. Only the last hierarchy of the tuples is ordered using the flag. The members of the other hierarchies are ordered using their rank (natural order).

In our example, [Licence] members are first ordered using their rank, afterwards [Geo] members are ordered using the flag. Check the test query to see a working example of the decomposition of this function.

**Query**

```
WITH
    SET [Set1] as Order( [Product].[Prod].[Licence].members, [Product].[Prod].currentMember.name, ASC)
SELECT
    [Measures].Amount on 0,
    Order( [Set1] *  [Geography].[Geo].[City].members, [Measures].[Amount], DESC) on 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;New York</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Los Angeles</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;San Francisco</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quebec</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Toronto</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Caracas</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
 <td>128</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
 <td>16</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Valencia</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
 <td>64</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
 <td>32</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Valencia</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quebec</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Toronto</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Los Angeles</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;New York</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;San Francisco</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Caracas</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
 <td>8</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
 <td>2</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
 <td>1</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Valencia</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quebec</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Toronto</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Los Angeles</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;New York</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;San Francisco</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Caracas</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quebec</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Toronto</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Los Angeles</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;New York</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;San Francisco</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Caracas</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Valencia</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    SET [AllMembers] AS  Hierarchize([Product].[Prod].[Licence].members)
SELECT
   [Measures].Amount on 0,

    Generate( [AllMembers] as s1,
        Order( s1.currentMember * [Geography].[Geo].[City].members, [Measures].[Amount], DESC) ) on 1
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(tuple-set,numeric,BDESC) - check empty

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
WITH
    SET [AllMembers] AS  Order({ [Product].[Prod].[Licence].&[Corporate],
                                 [Product].[Prod].[Licence].&[Partnership],
                                 [Product].[Prod].[Licence].&[Startup],
                                 [Product].[Prod].[Licence].&[Startup],
                                 [Product].[Prod].[Licence].&[Personal]
                               }
                               , [Measures].[Amount], BDESC )
SELECT
    [Measures].Amount on 0,
    [AllMembers] on 1
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Continent].[America]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    SET [AllMembers] AS  {
            [Product].[Prod].[Licence].&[Corporate],
            [Product].[Prod].[Licence].&[Partnership],
            [Product].[Prod].[Licence].&[Startup],
            [Product].[Prod].[Licence].&[Startup],
            [Product].[Prod].[Licence].&[Personal]
    }
SELECT
    [Measures].Amount on 0,
    [AllMembers] on 1
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Continent].[America]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Order(tuple-set,numeric,DESC) - check empty

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
WITH
    SET [AllMembers] AS  Order({ [Product].[Prod].[Licence].&[Corporate],
                                 [Product].[Prod].[Licence].&[Partnership],
                                 [Product].[Prod].[Licence].&[Startup],
                                 [Product].[Prod].[Licence].&[Startup],
                                 [Product].[Prod].[Licence].&[Personal]
                               }
                               , [Measures].[Amount], DESC )
SELECT
    [Measures].Amount on 0,
    [AllMembers] on 1
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Continent].[America]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    SET [AllMembers] AS  {
            [Product].[Prod].[Licence].&[Corporate],
            [Product].[Prod].[Licence].&[Partnership],
            [Product].[Prod].[Licence].&[Personal],
            [Product].[Prod].[Licence].&[Startup],
            [Product].[Prod].[Licence].&[Startup]
    }
SELECT
    [Measures].Amount on 0,
    [AllMembers] on 1
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Continent].[America]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### UnOrder( ... )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the set passed as parameter as this function currently does nothing.

**Query**

```
UnOrder( [Geography].[Geo].[Continent].Members )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].Members
```


 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
