## Operators

The following table lists the available operators and their descriptions.




### Description

Comparison

<pre>
Equal To (=)                    Compare two MDX expressions:
                                        NULL = false is true
                                        NULL = 0     is true

Not Equal To (<>)               Compare two MDX expressions:
                                        NULL <> false is false
                                        NULL <> 0     is false

Less Than (<)                   Compare two MDX expressions.

Less Than or Equal To (<=)      Compare two MDX expressions.

Greater Than (>)                Compare two MDX expressions.

Greater Than or Equal To (>=)   Compare two MDX expressions.
</pre>

Comparison (Strict)

<pre>
Equal To (==)                   Similar to the 'Equal To' operator except that:
                                        NULL == false is false
                                        NULL == 0     is false

Not Equal To (!=)               Similar to the 'Not Equal To' operator except that:
                                        NULL != false is true
                                        NULL != 0     is true

Less Than (<<)                  Similar to the 'Less Than' operator except that:
                                        0, false, "" are not considered as NULL

Less Than or Equal To (<<=)     Similar to the 'Less Than or Equal To' operator except that:
                                        0, false, "" are not considered as NULL

Greater Than (>>)               Similar to the 'Greater Than' operator except that:
                                        0, false, "" are not considered as NULL

Greater Than or Equal To (>>=)  Similar to the 'Greater Than or Equal To' operator except that:
                                        0, false, "" are not considered as NULL
</pre>

Logical

<pre>
And (AND)                       Logical and operation.

Or (OR)                         Logical or operation.

Not (NOT)                       Logical not operation.

Xor (XOR                        Logical xor operation.

Is (IS)                         Same MDX entities ([www](Is%20Operator.md)).

</pre>

Mathematical

<pre>
Add (+)                         Adds two scalar entities. Note that string entities are concatenated.

Subtract (-)                    Subtracts two scalar entities or unary negative operator.

Multiply (*)                    Multiplies two scalar entities.

Divide (/)                      Divides two scalar entities.

Power (^)                       Raises one scalar entity by a number.

</pre>

Others

<pre>
Crossjoin (*)                   Cross product of two sets ([www](Crossjoin.md)).

Except (-)                      Difference between two sets ([www](Except.md)).

Union (+)                       Union of two sets removing duplicates ([www](Union.md)).

Range (:)                       A set of members between two members ([www](Range%20Operator.md)).

</pre>



                                                                      

### See Also


[Crossjoin](Crossjoin.md)

[Except](Except.md)

[Range Operator](Range%20Operator.md)

[Is Operator](Is%20Operator.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
