## NonEmptyMembers

Return the list of members that are non-empty.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |measure |one | |
|limit |value-expression |zero-one | |



### Return

```
set
```



### Description

Returns a set of non-empty members from the first set.

This function filters out members that are empty. Empty members are the ones that have an empty value for the given measure.

The measure cannot be a calculated members.

The set cannot contain any calculated member.

The third parameter, if defined, limits the number of returned members.

This function is slightly faster than the NonEmpty function.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NonEmptyMembers(members, measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all set members that are non-empty, facts wise, from the set when evaluated using the specified measure.

In our example, this is equivalent to a Filter( ..., NOT isEmpty() ) statement.

**Query**

```
SELECT
    NonEmptyMembers([Geography].[Geo].[America].children, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">United States</td>
</tr>
<tr>
 <td>768</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    Filter( [Geography].[Geo].[America].children, NOT isEmpty( [Measures].[Amount] ) ) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NonEmptyMembers(members, measure, limit)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first two set members that are non-empty, facts wise, from the set when evaluated using the specified measure.

In our example, this is equivalent to a Filter( ..., NOT isEmpty() ).head(2) statement.

**Query**

```
SELECT
    NonEmptyMembers([Geography].[Geo].[America].children, [Measures].[Amount], 2) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">United States</td>
</tr>
<tr>
 <td>768</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    Filter( [Geography].[Geo].[America].children, NOT isEmpty( [Measures].[Amount] ) ).head(2) ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[NonEmpty](NonEmpty.md)

[NonEmptyX](NonEmptyX.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
