## NonEmpty

Return the list of tuples in the first set that are non-empty.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |measure |zero-one | |
|limit |value-expression |zero-one | |



### Return

```
set
```



### Description

Returns a set of non-empty tuples from the first set.

A single set as parameter:

This function filters out tuples that are empty. Empty tuples are the ones that have an empty value for the given measure. Missing members in the tuples are completed using the same logic than in the axis (slicer/default).

A set and a measure as parameter:

The processing is similar to the previous case using the specified measure instead of the measure in the current context.

Two sets as parameters:

This function returns the tuples in the first set that are non-empty when evaluated across the tuples of the second set.

The third parameter, if defined, limits the number of returned tuples or members (new since v6.8.10).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NonEmpty(tuple_set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all set members that are non-empty, facts wise, from the tuple set.

In our example, this is equivalent to NON EMPTY

**Query**

```
SELECT
    [Measures].[Amount] ON 0,
    NonEmpty([Geography].[Geo].[America].children) ON 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    [Measures].[Amount] ON 0,
    NON EMPTY [Geography].[Geo].[America].children ON 1
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NonEmpty(tuple_set, measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all set members that are non-empty, facts wise, from the tuple set when evaluated using the specified measure.

In our example, this is equivalent to a Filter( ..., NOT isEmpty() ) statement.

**Query**

```
SELECT
    NonEmpty([Geography].[Geo].[America].children, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">United States</td>
</tr>
<tr>
 <td>768</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    Filter( [Geography].[Geo].[America].children, NOT isEmpty( [Measures].[Amount] ) ) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NonEmpty(tuple_set, measure, limit)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first two set members that are non-empty, facts wise, from the tuple set when evaluated using the specified measure.

In our example, this is equivalent to a Filter( ..., NOT isEmpty() ).head(2) statement.

**Query**

```
SELECT
    NonEmpty([Geography].[Geo].[America].children, [Measures].[Amount], 2) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">United States</td>
</tr>
<tr>
 <td>768</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    Filter( [Geography].[Geo].[America].children, NOT isEmpty( [Measures].[Amount] ) ).head(2) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NonEmpty(tuple_set,tuple_set) - 

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all members of the first set that are non-empty, facts wise, for at least one combination with the members of the second set.

In our example, the query returns the total [Amount] for all countries which have a partnership product.

**Query**

```
SELECT
    [Measures].[Amount] ON 0,
    NonEmpty([Geography].[Geo].[City].members,[Product].[Partnership])  ON 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
 <td>56</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
 <td>64</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    [Measures].[Amount] ON 0,
    Filter([Geography].[Geo].[City].members as s,not isEmpty(s.currentMember* [Product].[Partnership]))  ON 1
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[IsEmpty](IsEmpty.md)

[Exists](Exists.md)

[Existing](Existing.md)

[NonEmptyMembers](NonEmptyMembers.md)

[NonEmptyX](NonEmptyX.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
