## Naming

MDX Entities naming examples




### Description

Several examples on MDX entities (members, dimensions, hierarchies) naming.


More information can be found in the following tests or in our MDX Gentle Introduction [here](../mdx_tutorial/member_name.md).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Case Insensitive

</div>

<div class="ic3-mdx-example-body" style="display:none">

MDX is not case sensitive. You can mix lower and upper cases both for the keywords and the names.

**Query**

```
SELECT
    [Measures].DefaultMember ON 0,
    [Geography].[Geo].[Continent].Members ON 1
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>255</td>
</tr>
</table>



**Assertion : Cell Equals**

```
select
    [measures].defaultMember on 0,
    [geography].[geo].[continent].members on 1
from
   [sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### No need for a fully qualified path

</div>

<div class="ic3-mdx-example-body" style="display:none">

MDX language does not need a fully qualified path (e.g., dimension.hierarchy) to define a member. If it's uniquely defined using its name only MDX will lookup into all the dimension hierarchies. This is not recommended for performance reason as this requires a longer lookup time.

**Query**

```
/* This is going to lookup in all hierarchies of all the dimensions */
[Lausanne]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Lausanne]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
/* This is going to lookup in all hierarchies of the [Geography] dimension */
[Geography].[Lausanne]
```


**Assertion : MDX Equals**

```
/* This is going to lookup into the [Geography].[Geo] hierarchy structure */
[Geography].[Geo].[Lausanne]
```


**Assertion : MDX Equals**

```
/* A fully qualified name lookup */
[Geography].[Geo].[Switzerland].[Lausanne]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Member Key Notation

</div>

<div class="ic3-mdx-example-body" style="display:none">

&[] notation is used to reference a member by its key instead of by its name.

**Query**

```
SELECT [Geography].[Geo].&[CH] ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT [Geography].[Geo].[Switzerland] ON 0 FROM [Sales]
```


 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
