## NameToSet

Returns a set containing a single member based on a string expression.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member |string-expression |one | |



### Return

```
member
```



### Description

Returns a set containing a single member based on a string expression. The string expression is converted into a member that is returned in a set.

If a member with specified name does not exist, an empty set is returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet('member')

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set containing the member as an MDX entity.

**Query**

```
NameToSet("[Geography].[Geo].[Zurich]")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Zurich]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Zurich]}
```


**Assertion : MDX Equals**

```
NameToSet('[Geography].[Geo].[Zurich]')
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet( 'unknown-member' )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if called with an unknown member.

**Query**

```
NameToSet( "[Geography].[Geo].[unknown-member]" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet( 'null' )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if called with a 'null'.

**Query**

```
NameToSet( 'null' )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : Cell Equals**

```
NameToSet( "null" )
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet(hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

NameToSet returns the default member of the hierarchy as a set.

**Query**

```
NameToSet('[Geography].[Geo]')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].DefaultMember
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet( single-hierarchy dimension )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the default member of the hierarchy as a set if called with a hierarchy or a dimension with a single hierarchy.

**Query**

```
NameToSet('[Product]')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Product].[Prod].[Company].[Crazy Development]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Product].DefaultMember
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet( null )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Cannot be applied to null; generates an error.

**Query**

```
NameToSet(null)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_MDX_EXPRESSION_EXPECTED](icCubeError.md#olap_mdx_expression_expected)</td></tr><tr><td>Error Message</td><td>

NameToSet() : expression expected : received a null/empty string expression.</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet('')

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an empty string parameter causes an error.

**Query**

```
NameToSet('')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_MDX_EXPRESSION_EXPECTED](icCubeError.md#olap_mdx_expression_expected)</td></tr><tr><td>Error Message</td><td>

NameToSet() : expression expected : received a null/empty string expression.</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter type causes an error.

**Query**

```
NameToSet("([Geography].[Geo].[Spain],[Product].[Licence].[Personal])")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

NameToSet() : argument (0) type mismatch: expected:'member', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter type causes an error.

**Query**

```
NameToSet("[Geography].[Geo].[Continent]")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

NameToSet() : argument (0) type mismatch: expected:'member', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet(memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter type causes an error.

**Query**

```
NameToSet("{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

NameToSet() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NameToSet(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter type causes an error.

**Query**

```
NameToSet("{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

NameToSet() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

                                                                         

### See Also


[StrToSet](StrToSet.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
