## MinusN

Returns the first parameter minus the second one, empty if ANY of the parameters is empty or null.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |numeric-expression |one | |
| |numeric-expression |one | |
| |numeric-expression |zero-one | |



### Return

```
numeric-value
```



### Description

This functions returns the first parameter minus the second one, if any of them is null or empty it will return empty.

MinusN(A,B) = A - B ; empty if A or B are null/empty

It will return the third parameter instead of null if the third parameter is defined (like a CoalesceEmpty).



### Since Version

4.7


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MinusN(A,B)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns A - B

**Query**

```
WITH
    MEMBER [minusN] AS minusN( ([Amount],[Geography].[Spain]) , ([Amount],[Geography].[France]) )
SELECT
    [minusN] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">minusN</td>
</tr>
<tr>
 <td>-1</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [minusN] AS ([Amount],[Geography].[Spain]) - ([Amount],[Geography].[France])
SELECT
    [minusN] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### minusN(A,B) - empty case

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns empty if one of the parameters is empty

**Query**

```
WITH
    MEMBER [minusN] AS MinusN( ([Amount],[Geography].[Spain]) , ([Amount],[Geography].[France],[Time].[2011]) )
SELECT
    [minusN] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">minusN</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [minusN] AS NULL
SELECT
    [minusN] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [minusN] AS minusN( ([Amount],[Geography].[Spain]) , NULL )
SELECT
    [minusN] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MinusN(A,B,0.0) - empty case with third parameter

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the third parameter if one of the parameters is empty.

**Query**

```
WITH
    MEMBER [minusN] AS MinusN( 2.0 , NULL, 0.0 )
SELECT
    [minusN] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">minusN</td>
</tr>
<tr>
 <td>0.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [minusN] AS CoalesceEmpty( MinusN( 2.0 , NULL), 0.0 )
SELECT
    [minusN] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[AddN](AddN.md)

[DivN](DivN.md)

[PercN](PercN.md)

[CoalesceEmpty](CoalesceEmpty.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
