## MemberToStr

Returns a unique MDX name of the member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |



### Return

```
string
```



### Description

Returns a unique MDX unique name (as a string) of the member.

Equivalent to: member.Properties('MEMBER_UNIQUE_NAME').



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MemberToStr(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a unique MDX name of the members as a string.

**Query**

```
WITH
    MEMBER [Measures].[Switzerland_Name] AS MemberToStr([Geography].[Geo].[Switzerland])
SELECT
    [Measures].[Switzerland_Name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland_Name</td>
</tr>
<tr>
 <td>[Geography].[Geo].[Country].&[CH]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Switzerland_Name] AS [Geography].[Geo].[Switzerland].Properties('MEMBER_UNIQUE_NAME')
SELECT
    [Measures].[Switzerland_Name] On 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MemberToStr(member) - NULL member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns '(null)' if the member is a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[Null_Name] AS MemberToStr(NULL)
SELECT
    [Measures].[Null_Name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Null_Name</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Null_Name] AS '(null)'
SELECT
    [Measures].[Null_Name] On 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MemberToStr(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS MemberToStr(([Geography].[Geo].[Spain],[Product].[Licence].[Personal]))
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : MemberToStr() : argument (0) type mismatch: expected:'member', got:'tuple'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MemberToStr(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS MemberToStr([Geography].[Geo].[Continent])
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : MemberToStr() : argument (0) type mismatch: expected:'member', got:'level'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MemberToStr(memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS MemberToStr({[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]})
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : MemberToStr() : argument (0) type mismatch: expected:'member', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MemberToStr(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS MemberToStr({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])})
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : MemberToStr() : argument (0) type mismatch: expected:'member', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MemberToStr(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS MemberToStr("hello")
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : MemberToStr() : argument (0) type mismatch: expected:'member', got:'string'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MemberToStr(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[V] AS MemberToStr( NULL )
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[V] AS NULL
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[SetToStr](SetToStr.md)

[StrToMember](StrToMember.md)

[TupleToStr](TupleToStr.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
