## Median

Returns the median value of the specified set expression.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |value-expression |zero-one | |



### Return

```
value
```



### Description

The median function calculates the median value of the non-empty cells.

1) A value expression is specified.

When the value expression is specified, the measure is evaluated over the set and its median value is returned.

2) A value expression is not specified.

If a value expression is not specified, the measure is taken from the current context.

How is the median value calculated ?

After sorting the set, the median value depends on the number of items :

a) if it's an odd number : returns the value of the member in the middle of the set.

b) if it's an even number : returns the average value of the two member in the middle of the set.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Median(set) - odd

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the median value of the set expression.

The set has an odd number of items; after sorting, the item in the middle is returned.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
    MEMBER [Geography].[Geo].[5]     AS 5.0

    MEMBER [Measures].[Median Amount] AS Median( {[Geography].[Geo].[5],[Geography].[Geo].[1], [Geography].[Geo].[3]}, [Measures].[Amount] )

SELECT
    [Measures].[Median Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Median Amount</td>
</tr>
<tr>
 <td>3.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Median Amount] AS 3.0
SELECT
    [Measures].[Median Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Median(set) - even

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the median value of the set expression.

The set has an even number of items; after sorting, the average of the both middle items is returned.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
    MEMBER [Geography].[Geo].[5]     AS 5.0
    MEMBER [Geography].[Geo].[7]     AS 7.0

    MEMBER [Measures].[Median Amount] AS Median( {[Geography].[Geo].[5],[Geography].[Geo].[3], [Geography].[Geo].[7], [Geography].[Geo].[1]}, [Measures].[Amount] )

SELECT
    [Measures].[Median Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Median Amount</td>
</tr>
<tr>
 <td>4.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Median Amount] AS 4.0
SELECT
    [Measures].[Median Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Median(set) - empty values

</div>

<div class="ic3-mdx-example-body" style="display:none">

Empty members are removed from the set.

In our example, the function ignores the [Empty] member giving the same result as applying it to the three first members.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
    MEMBER [Geography].[Geo].[5]     AS 5.0
    MEMBER [Geography].[Geo].[Empty] AS Null

    MEMBER [Measures].[Median Amount] AS Median( {[Geography].[Geo].[5],[Geography].[Geo].[1], [Geography].[Geo].[Empty], [Geography].[Geo].[3]}, [Measures].[Amount] )

SELECT
    [Measures].[Median Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Median Amount</td>
</tr>
<tr>
 <td>3.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Median Amount] AS 3.0
SELECT
    [Measures].[Median Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Median(NULL), Median({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty cell if applied to an empty set or a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[Median Amount] AS Median( null )
SELECT
    [Measures].[Median Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Median Amount</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Median Amount] AS Median({})
SELECT
    [Measures].[Median Amount] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Median Amount] AS null
SELECT
    [Measures].[Median Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Percentile](Percentile.md)

[Avg](Avg.md)

[Min](Min.md)

[Max](Max.md)

[Sum](Sum.md)

[Vector](Vector.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
