## MeasureGroupMeasures

Returns all measure members belonging to the specified measure group name.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-expression |one | |



### Return

```
set
```



### Description

Returns all measure members belonging to the specified group name. The function is case insensitive.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MeasureGroupMeasures(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all measures belonging to the parameter measure group.

In our case, {[Measures].[Fx]}

**Query**

```
with member fxName as MeasureGroupMeasures( 'fx' )(0).uniqueName
select from sales where fxName
```

 
**Result**

<pre>[Measures].[Fx]</pre>



**Assertion : MDX Equals**

```
with member fxName as [Measures].[Fx].uniqueName
select from sales where fxName
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MeasureGroupMeasures(string) - no existing measure group

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if there is no measure group.

**Query**

```
MeasureGroupMeasures( 'dfdfd' )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MeasureGroupMeasures(member) - 1

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
MeasureGroupMeasures([Geography].[Geo].[United States])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

MeasureGroupMeasures() : argument (0) type mismatch: expected:'string', got:'member'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MeasureGroupMeasures(tuple) - 1

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
MeasureGroupMeasures(([Geography].[Geo].[Spain],[Product].[Licence].[Personal]))
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

MeasureGroupMeasures() : argument (0) type mismatch: expected:'string', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MeasureGroupMeasures(level) - 2

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
MeasureGroupMeasures([Geography].[Geo].[Continent])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

MeasureGroupMeasures() : argument (0) type mismatch: expected:'string', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MeasureGroupMeasures(memberSet) - 2

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
MeasureGroupMeasures({[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

MeasureGroupMeasures() : argument (0) type mismatch: expected:'string', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MeasureGroupMeasures(tupleSet) - 2

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
MeasureGroupMeasures({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

MeasureGroupMeasures() : argument (0) type mismatch: expected:'string', got:'set'</td></tr></table>


 
</div>

                                                                         

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
