## Max

Returns the max value of the specified set expression.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |value-expression |zero-one | |



### Return

```
value
```



### Description

The max function calculates the max value of the non-empty cells.

1) A value expression is specified.

When the value expression is specified, the measure is evaluated over the set and its max value is returned.

2) A value expression is not specified.

If a value expression is not specified, the measure is taken from the current context.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Max(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the max value along the set.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
    MEMBER [Geography].[Geo].[Empty] AS Null

    MEMBER [Measures].[Max Amount] AS Max( {[Geography].[Geo].[1],[Geography].[Geo].[3], [Geography].[Geo].[Empty]}, [Measures].[Amount] )

SELECT
    [Measures].[Max Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Max Amount</td>
</tr>
<tr>
 <td>3.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Max Amount] AS 3.0
SELECT
    [Measures].[Max Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Max(set) - empty cells are ignored

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the max value along the set ignoring the empty cells.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS -1.0
    MEMBER [Geography].[Geo].[3]     AS -3.0
    MEMBER [Geography].[Geo].[Empty] AS Null

    MEMBER [Measures].[Max Amount] AS Max( {[Geography].[Geo].[1],[Geography].[Geo].[3], [Geography].[Geo].[Empty]}, [Measures].[Amount] )

SELECT
    [Measures].[Max Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Max Amount</td>
</tr>
<tr>
 <td>-1.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Max Amount] AS -1.0
SELECT
    [Measures].[Max Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Max(NULL), Max({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty cell if applied to an empty set or a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[Max Amount] AS Max( null )
SELECT
    [Measures].[Max Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Max Amount</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Max Amount] AS null
SELECT
    [Measures].[Max Amount] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Max Amount] AS Max({})
SELECT
    [Measures].[Max Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Avg](Avg.md)

[Min](Min.md)

[Median](Median.md)

[Sum](Sum.md)

[Vector](Vector.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
