## MatrixA

Returns a MatrixA.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |two | |
|value |numeric-expression |one | |



### Return

```
value
```



### Description

This function is similar to Matrix but returning a MatrixA. This new structure holds not only the numerical Matrix but also the information on the axis that generated it.

The MatrixA can be used to put the result into a modified MDX statement (SELECT [my-matrix] ON AXES ...) that will return the matrix as a standard MDX statement with Column and Rows.

MatrixA shares the same operations and scalar operators (+-*) as Matrix.

See this [page](../mdx_types/matrix.md) for all the available operations.



### Since Version

4.8


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixA(set,set,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A standard example of a MatrixA adding the result 'on Axes' so the matrix is expanded. Note that as in a matrix EMPTY/NULL are converted to 0.0 we're using a calculated member to simulate this operation.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] )
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>768.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>144.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>96.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>4.0</td>
 <td>3.0</td>
 <td>8.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[matrix-a-element] AS [Measures].[Amount] + 0.0 //  EMPTY + 0.0 = 0.0
SELECT
    [Geography].[Geo].[Country] on 0,
    [Product].[Prod].[Licence] on 1
FROM
    [Sales]
WHERE
    [Measures].[matrix-a-element]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixA(..)->Inverse()

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example using the inverse method of the Matrix, axes are swapped.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( nonempty([Geography].[Geo].[Country],[Measures].[Amount]).tail(4), [Product].[Prod].[Licence].head(4), [Measures].[Amount] + 2.0 )->inverse()
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Corporate</td>
  <td class="ic3-mdx-result-cell-header">Partnership</td>
  <td class="ic3-mdx-result-cell-header">Personal</td>
  <td class="ic3-mdx-result-cell-header">Startup</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>0.0013020833333333335</td>
 <td>-0.001953125</td>
 <td>5.767392335715099E-19</td>
 <td>6.510416666666651E-4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>0.003906250000000002</td>
 <td>-0.05794270833333328</td>
 <td>1.0000000000000002</td>
 <td>-2.4459635416666674</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>-0.005208333333333336</td>
 <td>0.0494791666666666</td>
 <td>-1.0000000000000004</td>
 <td>2.955729166666668</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>-0.0</td>
 <td>0.010416666666666666</td>
 <td>-0.0</td>
 <td>-0.010416666666666666</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixA(..)->Inverse() II

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to show we're actually calculating the matrix inverse.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( nonempty([Geography].[Geo].[Country],[Measures].[Amount]).tail(4), [Product].[Prod].[Licence].head(4), [Measures].[Amount] + 2.0 )
  MEMBER [Measures].[matrix-i] AS ([matrix-a]->inverse() * [matrix-a])->round(10)
SELECT
  [Measures].[matrix-i] on Axes
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>1.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>0.0</td>
 <td>1.0</td>
 <td>0.0</td>
 <td>0.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>1.0</td>
 <td>0.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>1.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1,0,0,0), VectorN(0,1,0,0), VectorN(0,0,1,0), VectorN(0,0,0,1) ).setAxes( nonempty([Geography].[Geo].[Country],[Measures].[Amount]).tail(4), [Product].[Prod].[Licence].head(4) )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixA(..) - Cell Properties

</div>

<div class="ic3-mdx-example-body" style="display:none">

This example shows the formatting of Matrix elements. Cell properties of Matrix elements use the properties defined by the calculated member. In this example we use the FORMAT_STRING.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] ),
            FORMAT_STRING = IIF( currentCellValue() <> 0.0, "j:%,3.2f", "j:-")

SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>-</td>
 <td>-</td>
 <td>768.00</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>144.00</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>96.00</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>4.00</td>
 <td>3.00</td>
 <td>8.00</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
 <td>-</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[matrix-a-element] AS [Measures].[Amount] + 0.0 , //  EMPTY + 0.0 = 0.0
              FORMAT_STRING = IIF( currentCellValue() <> 0.0, "j:%,3.2f", "j:-")
SELECT
    [Geography].[Geo].[Country] on 0,
    [Product].[Prod].[Licence] on 1
FROM
    [Sales]
WHERE
    [Measures].[matrix-a-element]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] ),
                                    FORMAT_STRING = IIF( currentCellValue() <> 0.0, "j:%,3.2f", "j:-")
    MEMBER [Measures].[matrix-a-element] AS [Measures].[matrix-a].elementValue()

SELECT
    [Geography].[Geo].[Country] on 0,
    [Product].[Prod].[Licence] on 1
FROM
    [Sales]
WHERE
    [Measures].[matrix-a-element]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixA(..) - operator + 

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixA class support the + operator.

In this example, ( (1,2),(3,4) ) + 2 = ( (3,5),(5,6) )

**Query**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA ( MatrixN( VectorN(1,2), VectorN(3,4) ) )  + 2
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>3.0</td>
 <td>5.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>4.0</td>
 <td>6.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS 2 + toA( MatrixN( VectorN(1,2), VectorN(3,4) ) )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( MatrixN( VectorN(1+2,2+2), VectorN(3+2,4+2) ) )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Matrix(..) - operator -

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixA class support the + operator.

In this example, ( (1,2),(3,4) ) - 2 = ( (-1,0),(1,2) )

**Query**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( MatrixN( VectorN(1,2), VectorN(3,4) ) ) - 2
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>-1.0</td>
 <td>1.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>0.0</td>
 <td>2.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS (-2) + toA( MatrixN( VectorN(1,2), VectorN(3,4) ) )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( MatrixN( VectorN(1-2,2-2), VectorN(3-2,4-2) ) )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixA(..) - operator *

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixA class support the + operator.

In this example, ( (1,2),(3,4) ) * 2 = ( (2,4),(6,8) )

**Query**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( MatrixN( VectorN(1,2), VectorN(3,4) )  * 2 )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>2.0</td>
 <td>6.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>4.0</td>
 <td>8.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( 2 * MatrixN( VectorN(1,2), VectorN(3,4) ) )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( MatrixN( VectorN(1*2,2*2), VectorN(3*2,4*2) ) )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixA(..) - operator / 

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixA class support the / operator.

In this example, ( (1,2),(3,4) ) / 2 = ( (1/2,2/2),(3/2,4/2) )

**Query**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( MatrixN( VectorN(1,2), VectorN(3,4) ) /  2 )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>0.5</td>
 <td>1.5</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>1.0</td>
 <td>2.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( MatrixN( VectorN(1/2,2/2), VectorN(3/2,4/2) ) )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixA(..) - operator * (Vector) 

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixA class support the * operator with a vector

In this example, ( (11,12),(21,22) ) * (1,2) = ( 11*1 + 21*2, 12*1 + 22*2 )

**Query**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Geography].[Geo].[Country],2), Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( MatrixN( VectorN(11,12), VectorN(21,22) ) ) * VectorN(1,2)
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>53.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>56.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    FUNCTION toA( a_ ) AS a_.SetAxes( Head([Product].[Prod].[Licence],2) )
    MEMBER [Measures].[val] AS toA( VectorN( 11*1 + 21*2, 12*1 + 22*2 ) )
SELECT
    [Measures].[val] ON Axes
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Matrix](Matrix.md)

[ElementValue](ElementValue.md)

[SetAxes](SetAxes.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
