## LookupByKey

Returns the first member, or a list of members, in a given level/hierarchy matching the parameter key.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |dimension-hierarchy-level-expression |one | |
| |value-expression |zero-n | |
| |member-expression |zero-one | |
| |set-member-expression |zero-one | |
| |TYPED |zero-one | |



### Return

```
member|set-members
```



### Description

The function returns the first member matching the key specified in the value expression. You can specify several lookup values for multi-values keys. If TYPED options is used the
key values will not be converted to the expected types.

if the second parameter is a measure or a calculated member, the key is the evaluated value of the member.

If the second parameter is a member, the key is used as value-expression.

If the second parameter is a set of members, it will return a set of matching member.

If a hierarchy is specified, the algorithm will start at the first level and continue until a matching member is found.

It is similar to strToMember("Level-expression" + "&[" + value-expression + "]") function, but faster and specially useful when the key is a date or a time object.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByKey(level,key)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member in the specified level matching the specified member key.

In our example, we return the [United States] of the hierarchy [Economy].

**Query**

```
LookupByKey([Geography].[Economy].[Country],[Geography].[Economy].[United States].key)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Economy].[Country].[United States]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Economy].[United States]
```


**Assertion : MDX Equals**

```
strToMember( "[Geography].[Economy].&[" + [Geography].[Economy].[United States].key + "]" )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByKey(hierarchy,key)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member in the specified hierarchy matching the specified member key.

In our example, we return the [United States] of the hierarchy [Economy].

**Query**

```
LookupByKey([Geography].[Economy],[Geography].[Economy].[United States].key)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Economy].[Country].[United States]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Economy].[United States]
```


**Assertion : MDX Equals**

```
strToMember( "[Geography].[Economy].&[" + [Geography].[Economy].[United States].key + "]" )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByKey(level,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member in the specified level matching the specified member key.

In our example, we return the [United States] of the hierarchy [Economy].

**Query**

```
WITH
MEMBER MyKey AS [Geography].[Economy].[United States].key
SELECT
LookupByKey([Geography].[Economy].[Country], [MyKey]) on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">United States</td>
</tr>
<tr>
 <td>768</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
LookupByKey([Geography].[Economy].[Country],[Geography].[Economy].[United States].key) on 0
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByKey(hierarchy,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member in the specified hierarchy matching the specified member key.

In our example, we return the [United States] of the hierarchy [Economy].

**Query**

```
LookupByKey([Geography].[Economy],[Geography].[Economy].[United States])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Economy].[Country].[United States]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Economy].[United States]
```


**Assertion : MDX Equals**

```
strToMember( "[Geography].[Economy].&[" + [Geography].[Economy].[United States].key + "]" )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByKey(hierarchy,set-members)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a list of matching members for each member of the second parameter.

In our example, we return the [United States] of the hierarchy [Economy].

**Query**

```
LookupByKey([Geography].[Economy],{[Geography].[Economy].[United States],[Geography].[Economy].[France]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Economy].[Country].[United States], 
  [Geography].[Economy].[Country].[France]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Economy].[United States],[Geography].[Economy].[France]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByKey(hierarchy,key,TYPED)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member in the specified hierarchy matching the specified member key without converting
the key.

In our example, we return the [United States] of the hierarchy [Economy].

**Query**

```
LookupByKey([Geography].[Economy],[Geography].[Economy].[United States].key,TYPED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Economy].[Country].[United States]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Economy].[United States]
```


**Assertion : MDX Equals**

```
strToMember( "[Geography].[Economy].&[" + [Geography].[Economy].[United States].key + "]" )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByKey(level,key) - member not found

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if there is no matching member in the specified level.

In our example, there is no member in level [Continent] with key '232'.

**Query**

```
LookupByKey([Geography].[Continent],232)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


**Assertion : MDX Equals**

```
LookupByKey([Geography].[Continent],"232")
```


**Assertion : MDX Equals**

```
LookupByKey([Geography].[Continent],3.24)
```


 
</div>

                                                                                                            

### See Also


[LookupByKeys](LookupByKeys.md)

[LookupByName](LookupByName.md)

[LinkMember](LinkMember.md)

[StrToMember](StrToMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
