## Level

Returns the level of the specified member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |



### Return

```
level
```



### Description

Returns the level of the specified member.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Level( member )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the level of the [Spain] member : [Country].

**Query**

```
WITH MEMBER [level-name] AS [Geography].[Geo].[Spain].level.uniqueName
SELECT [level-name] ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">level-name</td>
</tr>
<tr>
 <td>[Geography].[Geo].[Country]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH MEMBER [level-name] AS Level( [Geography].[Geo].[Spain] ).uniqueName
SELECT [level-name] ON 0 FROM [Sales]
```


**Assertion : Cell Equals**

```
WITH MEMBER [level-name] AS [Geography].[Geo].[Country].uniqueName
SELECT [level-name] ON 0 FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[Levels](Levels.md)

[FirstNotAllLevel](FirstNotAllLevel.md)

[LastLevel](LastLevel.md)

[Dimension](Dimension.md)

[Hierarchy](Hierarchy.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
