## LastSibling

Returns the last child of the parent of the specified member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |



### Return

```
member
```



### Description

The function returns the last child of the parent of the specified member.

Equivalent to : [specified-member].Parent.LastChild

If the specified member has no parent, returns the last member of its level.

Equivalent to: Tail( [specified-member].Level.Members )



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.LastSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the last sibling of the specified member. Equivalent to: member.Parent.LasChild.

In our example, the last month of 2010, [Dec 2010].

**Query**

```
[Time].[May 2010].LastSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jun 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Time].[May 2010].Parent.LastChild
```


**Assertion : MDX Equals**

```
Tail([Time].[May 2010].Parent.Children)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.LastSibling - no parent

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the member has no parent, returns the last member of the level of the specified member. Equivalent to: Tail( member.Level.Members ).

In our example, the last year.

**Query**

```
[Time].[2010].LastSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Year].[2011]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Tail( [Time].[2010].Level.Members )
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NULL.LastSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
NULL.LastSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tuple.LastSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter type causes an error.

**Query**

```
([Geography].[Geo].[Spain],[Product].[Licence].[Personal]).LastSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

LastSibling() : argument (0) type mismatch: expected:'member', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### level.LastSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter type causes an error.

**Query**

```
[Geography].[Geo].[Continent].LastSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

LastSibling() : argument (0) type mismatch: expected:'member', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### memberSet.LastSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter type causes an error.

**Query**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}.LastSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

LastSibling() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tupleSet.LastSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter type causes an error.

**Query**

```
{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}.LastSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

LastSibling() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### string.LastSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter type causes an error.

**Query**

```
"hello".LastSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

LastSibling() : argument (0) type mismatch: expected:'member', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[IsSibling](IsSibling.md)

[FirstSibling](FirstSibling.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
