## LastPeriods

Returns the members that stand before the specified member including the specified member itself within the level members.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|index |numeric-expression |one | |
| |member-expression |one | |



### Return

```
set
```



### Description

This function returns the (index-1) members that are before the specified member including the member itself within the list of members of the level of the specified member.

a) if the index is positive, returns { member.lag(index), member.lag(index-1),... member}
b) if the index is negative, returns {member, member.lead(1),... member.lead(-index) }

If the index is 0, an empty set is returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LastPeriods(index,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set containing index members and ranging from member.lag(index) to the specified member.

In our example, {[Nov 2010],[Dec 2010]}.

**Query**

```
LastPeriods(2,[Time].[Calendar].[Dec 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Nov 2010], 
  [Time].[Calendar].[Month].[Dec 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Time].[Calendar].[Nov 2010],[Time].[Calendar].[Dec 2010]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LastPeriods(index,member) - negative index

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the index is negative the function returns the index next members of the level (i.e., moving forward instead of backward). In our case: { [Jun 2010], [Jul 2010] }.

**Query**

```
LastPeriods(-2,[Time].[Calendar].[Jun 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jun 2010], 
  [Time].[Calendar].[Month].[Jul 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Time].[Calendar].[Jun 2010],[Time].[Calendar].[Jul 2010]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LastPeriods(1,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the function with an index of 1 will return the specified member only.

**Query**

```
LastPeriods(1,[Geography].[Geo].[Switzerland].[Zurich])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Zurich]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Switzerland].[Zurich]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LastPeriods(0,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the function with an index of 0 will return an empty set.

**Query**

```
LastPeriods(0,[Geography].[Geo].[Switzerland].[Zurich])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LastPeriods(numeric,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to NULL this function is returning an empty set.

**Query**

```
LastPeriods( 0, NULL )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                         

### See Also


[Lag](Lag.md)

[Lead](Lead.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
