## IndexOf

Return the zero based position of the member in the set; -1 otherwise.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member-set |set-member-expression |one | |
|member |member-expression |one | |



### Return

```
numeric-value
```



### Description

The function returns the zero based position of the member in the given set. It returns -1 if the member
is not found in the set.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IndexOf(members, member) - found

</div>

<div class="ic3-mdx-example-body" style="display:none">

Return the zero-based position of the member in the list. In our example '2', as it's the third member.

**Query**

```
IndexOf( {[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain], [Geography].[Geo].[America], [Geography].[Geo].[France] }, [Geography].[Geo].[America] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2</td></tr></table>


**Assertion : MDX Equals**

```
2
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IndexOf(members, member) - not found

</div>

<div class="ic3-mdx-example-body" style="display:none">

Return -1 if the member is not in the parameter set.

**Query**

```
IndexOf( {[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain], [Geography].[Geo].[France] }, [Geography].[Geo].[America] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>-1</td></tr></table>


**Assertion : MDX Equals**

```
-1
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IndexOf(NULL, member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Return -1 if it's a NULL or empty set.

**Query**

```
IndexOf( {}, [Geography].[Geo].[America] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>-1</td></tr></table>


**Assertion : MDX Equals**

```
-1
```


**Assertion : MDX Equals**

```
IndexOf( NULL, [Geography].[Geo].[America] )
```


 
</div>

                                                                         

### See Also


[IsIn](IsIn.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
