## Iif

Evaluates the logical expression; if true returns the first expression, the second expression otherwise.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|condition |boolean-expression |one | |
|true-expression |expression |one | |
|false-expression |expression |one | |



### Return

```
any
```



### Description

The IIF function first evaluates the logical expression :

a) if true, returns the first expression.

b) if false (or NULL), returns the second expression.

The returned expressions can be any valid MDX expressions (numeric, strings, sets, tuples).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IIF(condition,expression,expression)

</div>

<div class="ic3-mdx-example-body" style="display:none">

IIF works in a similar way as the Excel function. If the condition is true returns the first expression, if false returns the second one.

In our example, we return '1' for [America] and '[Measures].[Amount] * 2' for the other cases.

**Query**

```
WITH
    MEMBER [Measures].[Simple] AS IIF( [Geography].[Geo].CurrentMember IS [Geography].[Geo].[America], 1, [Measures].[Amount] * 2 )
SELECT
   {[Geography].[Geo].[America],[Geography].[Geo].[Europe]} * [Measures].[Simple] ON 0
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">America</td>
  <td class="ic3-mdx-result-cell-header">Europe</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Simple</td>
  <td class="ic3-mdx-result-cell-header">Simple</td>
</tr>
<tr>
 <td>1</td>
 <td>510</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[True] AS 1
    MEMBER [Measures].[False] AS [Measures].[Amount] * 2
SELECT
    {([Geography].[Geo].[America],[Measures].[True]),([Geography].[Geo].[Europe],[Measures].[False])} ON 0
FROM
   [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IIF(condition,set,set) - in Axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

IIF function can be used within an axis definition.

In our example, we return only the children of [America].

**Query**

```
SELECT
   Generate({[Geography].[Geo].[America],[Geography].[Geo].[Europe]},
            IIF( [Geography].[Geo].currentMember IS [Geography].[Geo].[Europe],
            {}
            ,[Geography].[Geo].currentMember.children ) ) ON 0
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
</tr>
<tr>
 <td></td>
 <td></td>
 <td>768</td>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    [Geography].[Geo].[America].children ON 0
FROM
   [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NULL's argument

</div>

<div class="ic3-mdx-example-body" style="display:none">

NULL as condition is evaluated to false.

**Query**

```
WITH
    MEMBER [Measures].[P] AS IIF(null, "TRUE", "FALSE")
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">P</td>
</tr>
<tr>
 <td>FALSE</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[P] AS "FALSE"
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### No parameters

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
WITH
    MEMBER [Measures].[P] AS IIF()
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT_X](icCubeError.md#olap_function_unexpected_argument_count_x)</td></tr><tr><td>Error Message</td><td>

Iif() : unexpected number of parameters '0' (expected:'3:3')</td></tr></table>


 
</div>

                                                                         

### See Also


[Divide](Divide.md)

[DivN](DivN.md)

[CoalesceEmpty](CoalesceEmpty.md)

[CoalesceNull](CoalesceNull.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
