## Hierarchize

Return the members of the set sorted according to their natural order in their hierarchy.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |POST |zero-one | |



### Return

```
set
```



### Description

Return the members sorted in the set according to their hierarchy natural order.

In the 'natural' order children are positioned after their parents. The position of the children is defined during the creation of the hierarchy. This 'natural' position cannot be changed in an MDX query. The rank function should be used to sort members using another criteria.

If the POST flag is specified than children will be positioned before their parents.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Hierarchize(member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the set sorted in the natural order.

**Query**

```
Hierarchize(
    {
        [Geography].[Geo].[Madrid],
        [Geography].[Geo].[Barcelona],
        [Geography].[Geo].[Paris],
        [Geography].[Geo].[Europe],
        [Geography].[Geo].[Spain]
    }
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Europe],[Geography].[Geo].[Paris],[Geography].[Geo].[Spain],[Geography].[Geo].[Barcelona],[Geography].[Geo].[Madrid]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Hierarchize(member-set,POST)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Parents are positioned after their children.

**Query**

```
Hierarchize(
    {
        [Geography].[Geo].[Madrid],
        [Geography].[Geo].[Paris],
        [Geography].[Geo].[Barcelona],
        [Geography].[Geo].[Europe],
        [Geography].[Geo].[Spain]
    },
    POST
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Paris],[Geography].[Geo].[Barcelona],[Geography].[Geo].[Madrid],[Geography].[Geo].[Spain],[Geography].[Geo].[Europe]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Hierarchize(NULL), Hierarchize({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if applied to a NULL entity or an empty set.

**Query**

```
Hierarchize(null)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Hierarchize({})
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Hierarchize(member-set,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
Hierarchize( { [Geography].[Geo].[Paris] }, "hello" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Hierarchize() : argument (1) type mismatch: expected:'[POST]', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Rank](Rank.md)

[Children](Children.md)

[Members](Members.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
