## GetPropertyUniqueValues

Returns the unique values of a level's property.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |level-expression |one | |
| |string |one | |
| |boolean-expression |zero-one | |
|limit |number |zero-one | |



### Return

```
list
```



### Description

Returns the unique values of a level's property (mainly used by the icCube Dashboards application). Note that each property value is returned as its typed value (i.e., not as a string).

An optional boolean-expression allows for filtering the list of properties. Use the currentValue() function to retrieve the value of the current property. This boolean expression cannot evaluate any tuple.



### Since Version

8.0.0.rc-4


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### List of Values

</div>

<div class="ic3-mdx-example-body" style="display:none">

Retrieve the list of the country property attached to each city member.

**Query**

```
GetPropertyUniqueValues( [Geography].[Geo].[City], "Country")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>[Canada, Mexico, United States, Venezuela, France, Spain, Switzerland]</td></tr></table>


**Assertion : MDX Equals**

```
GetPropertyUniqueValues( [Geography].[Geo].[City], "Country")
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### List of Values w/ Predicate

</div>

<div class="ic3-mdx-example-body" style="display:none">

Retrieve the list of the country property attached to each city member. This list is filtered with a given predicate; note the usage of the currentValue() function.

**Query**

```
GetPropertyUniqueValues( [Geography].[Geo].[City], "Country", PatternMatchesContains("United", currentValue(), CASE_INSENSITIVE))
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>[United States]</td></tr></table>


**Assertion : MDX Equals**

```
GetPropertyUniqueValues( [Geography].[Geo].[City], "Country", "United States" = currentValue())
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### List Item

</div>

<div class="ic3-mdx-example-body" style="display:none">

Retrieve the list of the country property attached to each city member and return the first item of the list.

**Query**

```
GetPropertyUniqueValues( [Geography].[Geo].[City], "Country")->get(0)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Canada</td></tr></table>


**Assertion : MDX Equals**

```
"Canada"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### List Size

</div>

<div class="ic3-mdx-example-body" style="display:none">

Retrieve the number of unique countries.

**Query**

```
GetPropertyUniqueValues( [Geography].[Geo].[City], "Country")->size()
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>7</td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Country].count()
```


**Assertion : MDX Equals**

```
7
```


 
</div>

                                                                                                            

### See Also


[Properties](Properties.md)

[GetProperty](GetProperty.md)

[Dimension Properties](Dimension%20Properties.md)

[Member Custom Property](Member%20Custom%20Property.md)

[Member Attributes](Member%20Attributes.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
