## GetProperty

Returns the property for a measure or member, null if not defined.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
| |TYPED |one | |



### Return

```
numeric-value
```



### Description

Returns the property for a measure or member defined by the second parameter, null if not defined.

For members, the second parameter works as for the Properties function.

Since version 8.2 parent properties are also accessible from the children.



### Since Version

6.8.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.GetProperty('MEMBER_NAME')

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the property as a string. Note that property names are not case-sensitive.

In our example, returns the name of the member.

**Query**

```
WITH
    MEMBER [Measures].[PARIS_NAME] AS [Geography].[Geo].[Paris].GetProperty('MEMBER_NAME')
SELECT
    [Measures].[PARIS_NAME] On 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">PARIS_NAME</td>
</tr>
<tr>
 <td>Paris</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[PARIS_NAME] AS [Geography].[Geo].[Paris].Properties('MEMBER_NAME')
SELECT
    [Measures].[PARIS_NAME] On 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.GetProperty('MISSING') - not existing property

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns null as the property does not exist.

**Query**

```
WITH
    MEMBER [Measures].[PARIS_NAME] AS [Geography].[Geo].[Paris].GetProperty('MISSING')
SELECT
    [Measures].[PARIS_NAME] On 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">PARIS_NAME</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[PARIS_NAME] AS NULL
SELECT
    [Measures].[PARIS_NAME] On 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### measure.GetProperty(propertyName) - boolean

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the property defined by the key (string).

In our case, we set the property to retrieve it just afterwards

**Query**

```
WITH
    MEMBER [Measures].[Fx Prop] AS [Measures].[Amount].setProperty("fx",true).getProperty("fx",TYPED)
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Fx Prop</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Fx Prop] AS true
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### measure.GetProperty(propertyName) - numeric

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the property defined by the key (string).

In our case, we set the property to retrieve it just afterwards

**Query**

```
WITH
    MEMBER [Measures].[Fx Prop] AS [Measures].[Amount].setProperty("fx",3.14).getProperty("fx",TYPED)
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Fx Prop</td>
</tr>
<tr>
 <td>3.14</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Fx Prop] AS 3.14
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### measure.GetProperty(propertyName) - string

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the property defined by the key (string).

In our case, we set the property to retrieve it just afterwards

**Query**

```
WITH
    MEMBER [Measures].[Fx Prop] AS [Measures].[Amount].setProperty("fx","Got it !").getProperty("fx")
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Fx Prop</td>
</tr>
<tr>
 <td>Got it !</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Fx Prop] AS "Got it !"
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### measure.GetProperty(propertyName) - null

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns null if the property defined by the key is not found.

**Query**

```
WITH
    MEMBER [Measures].[Fx Prop] AS [Measures].[Amount].setProperty("fx","Got it !").getProperty("missing")
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Fx Prop</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Fx Prop] AS NULL
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Properties](Properties.md)

[GetPropertyUniqueValues](GetPropertyUniqueValues.md)

[Dimension Properties](Dimension%20Properties.md)

[Member Custom Property](Member%20Custom%20Property.md)

[Member Attributes](Member%20Attributes.md)

[SetProperty](SetProperty.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
