## GetMonitoringCounter

Returns the current value of the monitoring counter.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-expression |one | |



### Return

```
value
```



### Description

The function returns the current or instant value of the requested [monitoring counter](icCubeCounters.md#format_string).

Note that the list of available counters might change from one JVM to another.

Note that you need a role with " Monitoring / Counters " rights in order to access this function.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### GetMonitoringCounter

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the current value for the JVM free memory in megabytes.

**Query**

```
WITH
 MEMBER MemFreeCounter AS GetMonitoringCounter("Free Memory (Mb)")
SELECT
 [MemFreeCounter] on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">MemFreeCounter</td>
</tr>
<tr>
 <td>66.1855239868164</td>
</tr>
</table>



 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### GetMonitoringCounter - invalid counter

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid counter name will return an empty cell

**Query**

```
GetMonitoringCounter("My Invalid Counter")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                         

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
