## Generate

Applies to the first set members, all the members of the second set. Can also be used to concatenate strings.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |set-string-expression |one | |
| |string-expression |zero-one | |
| |ALL |zero-one | |



### Return

```
set-string
```



### Description

For each member of the first parameter set:

1) If the second parameter is a set expression, concatenates its elements (union).
ALL can be used as third parameter to keep duplicate member/tuples.

2) If the second parameter is a string expression, concatenates those strings.
If a delimiter string is defined, it will be used as a separator.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Generate(set,set_expression) - easy example

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns for each member of { [America], [Europe] } its firstChild.

**Query**

```
Generate( {[Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe]},
          {[Geography].[Geo].currentMember.firstChild}
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[France]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Continent].[America].firstChild, [Geography].[Geo].[Continent].[Europe].firstChild}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Generate(set,set_expression) - classical TopCount example

</div>

<div class="ic3-mdx-example-body" style="display:none">

A classical example, for each continent we get the top (Country,Licence) tuple.

Note the usage of .currentMember and named set (s1).

**Query**

```
Generate( [Geography].[Geo].[Continent].members as s1,
          TopCount(  s1.CurrentMember.children * [Product].[Prod].[Licence].Members, 1, [Measures].[Amount] ) )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Country].[United States], [Product].[Prod].[Licence].[Corporate] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Product].[Prod].[Licence].[Corporate] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Generate( [Geography].[Geo].[Continent].members,
          TopCount(  [Geography].[Geo].CurrentMember.children * [Product].[Prod].[Licence].Members, 1, [Measures].[Amount] ) )
```


**Assertion : MDX Equals**

```
Union(
    TopCount( [Geography].[Geo].[Continent].[America].children * [Product].[Prod].[Licence].Members, 1, [Measures].[Amount] ),
    TopCount( [Geography].[Geo].[Continent].[Europe].children  * [Product].[Prod].[Licence].Members, 1, [Measures].[Amount] )
)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Generate(set,set_expression,ALL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

The ALL flag allows for retaining duplicates members/tuples.

Our example is keeping two instances of [America].

**Query**

```
Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[America] },{[Geography].[Geo].CurrentMember}, ALL )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Continent].[America],[Geography].[Geo].[Continent].[America]}
```


**Assertion : MDX Equals**

```
Union({[Geography].[Geo].[Continent].[America]},{[Geography].[Geo].[Continent].[America]},ALL)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Generate(set,set_expression) - example with tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example of the generate function using tuples instead of members.

Note the usage of .currentMember returning a tuple and the usage of a named set (s1).

**Query**

```
Generate( { {[Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } * [Time].[Calendar].[2010] } as s1,
          TopCount(  s1.CurrentMember * [Product].[Prod].[Licence].Members, 1, [Measures].[Amount] ) )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2010], [Product].[Prod].[Licence].[Corporate] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Year].[2010], [Product].[Prod].[Licence].[Corporate] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Union(
    TopCount( {[Geography].[Geo].[Continent].[America]} * [Time].[Calendar].[2010] * [Product].[Prod].[Licence].Members, 1, [Measures].[Amount] ),
    TopCount( {[Geography].[Geo].[Continent].[Europe]}  * [Time].[Calendar].[2010] * [Product].[Prod].[Licence].Members, 1, [Measures].[Amount] )
)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Generate(set,string_expression,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Generates concatenates also string expressions using the delimiter defined by the third expression.

In our example, the set {[America],[Europe]} is converted into "America-Europe".

**Query**

```
WITH
    MEMBER [Measures].[Names] AS Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } AS countries, countries.CurrentMember.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Generate(set,string_expression)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Generates concatenates also string expressions (without delimiter).

In our example, the set {[America],[Europe]} is converted into "AmericaEurope".

**Query**

```
WITH
    MEMBER [Measures].[Names] AS Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } AS countries, countries.CurrentMember.Name )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>AmericaEurope</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "AmericaEurope"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Auto-exists

</div>

<div class="ic3-mdx-example-body" style="display:none">

Within the generate iteration auto-exists between France and Spain is applied.

**Query**

```
SELECT
    Iif( Generate( { [Geography].[Economy].[Spain] }, Iif(( [Geography].[Geo].[France], [Measures].[Amount] ) = 4 , 'exist', 'no' )) = 'exist',
         [Time].[Calendar].[2011],
         [Time].[Calendar].[2010]
    ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">2010</td>
</tr>
<tr>
 <td>1023</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT [Time].[Calendar].[2010] ON 0 FROM [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Missing parameter

</div>

<div class="ic3-mdx-example-body" style="display:none">

Missing parameter generates an error.

**Query**

```
Generate( { [Geography].[Geo].[France].children } )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

Generate() : unexpected number of parameters '1' (expected:'3,2')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Generate null

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if applied to a NULL entity.

**Query**

```
Generate(null,null)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


**Assertion : MDX Equals**

```
Generate( {}, { [Measures].[Amount] } )
```


**Assertion : MDX Equals**

```
Generate({},null)
```


**Assertion : MDX Equals**

```
Generate( {}, {} )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Invalid ALL flag

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid flag causes error.

**Query**

```
Generate( {}, {}, CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Generate() : OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH [2, ALL, OPTION]</td></tr></table>


 
</div>

                                                                         

### See Also


[Union](Union.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
