## FirstSibling

Returns the first child of the parent of the specified member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression | | |



### Return

```
member
```



### Description

The function returns the first child of the parent of the specified member.

Equivalent to Parent.FirstChild or Parent.children(0).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.FirstSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first sibling of the member.

Equivalent to Parent.FirstChild.

**Query**

```
[Time].[May 2010].FirstSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Apr 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Time].[May 2010].Parent.FirstChild
```


**Assertion : MDX Equals**

```
Head([Time].[May 2010].Parent.Children)
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NULL.FirstSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
NULL.FirstSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tuple.FirstSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
([Geography].[Geo].[Spain],[Product].[Licence].[Personal]).FirstSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

FirstSibling() : argument (0) type mismatch: expected:'member', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### level.FirstSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
[Geography].[Geo].[Continent].FirstSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

FirstSibling() : argument (0) type mismatch: expected:'member', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### memberSet.FirstSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}.FirstSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

FirstSibling() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tupleSet.FirstSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}.FirstSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

FirstSibling() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### string.FirstSibling

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
"hello".FirstSibling
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

FirstSibling() : argument (0) type mismatch: expected:'member', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[IsSibling](IsSibling.md)

[LastSibling](LastSibling.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
