## FirstNotAllLevel

Returns the first not all level of a hierarchy


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |hierarchy-expression |one | |



### Return

```
level
```



### Description

Returns the first level of the hierarchy excluding the all level.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### FirstNotAllLevel(hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first, not all, level of the hierarchy.

In our example, [Geo].[Continent] as it's the second level of [Geo] hierarchy

**Query**

```
FirstNotAllLevel([Geography].[Geo])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent]
```


**Assertion : MDX Equals**

```
[Geography].[Geo].levels( 1 ) // 0 is [All]
```


**Assertion : Cell Equals**

```
[Geography].[Geo].FirstNotAllLevel()
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### FirstNotAllLevel(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
FirstNotAllLevel(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                         

### See Also


[Level](Level.md)

[Levels](Levels.md)

[LastLevel](LastLevel.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
