## ExtractOthers

Returns a set of tuples extracting the not specified hierarchies (others as specified)


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |hierarchy-expression |one-n | |



### Return

```
set
```



### Description

For each tuple in the specified set, this functions extracts the members of the no specified hierarchies into a new tuple (extract the others). These new tuples are combined into a new set returned by this function.

This function works as the Extract() function but by extracting the 'others' hierarchies. For example, if you want to remove the measures from your set-expression you would use [Measures] as second parameter.

Note that this function removes duplicate elements.



### Since Version

4.7


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ExtractOthers(set,hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the set, extracting from all tuples the hierarchy specified.

In our example, the function removes from the tuple the member of the [Measures] hierarchy.

**Query**

```
ExtractOthers( { ([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])} * {[Measures].[Amount]}, [Measures] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Country].[Canada], [Geography].[Economy].[Country].[Canada] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ExtractOthers(set,hierarchy) - duplicates are removed

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the set, extracting from all tuples the hierarchy specified. Duplicated tuples are removed.

In our example, the function removes from the tuple the member of the [Geography].[Economy] hierarchy.

**Query**

```
ExtractOthers( { ([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}+{([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}, [Geography].[Geo] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Economy].[Country].[Canada]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Canada]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ExtractOthers(set,hierarchy) - fully removed

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if the tuples are fully removed (all members of the tuple are removed).

**Query**

```
ExtractOthers( {([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}, [Geography].[Geo],[Geography].[Economy] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ExtractOthers({},hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if an empty set is specified.

**Query**

```
ExtractOthers( {}, [Geography].[Geo] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                         

### See Also


[Extract](Extract.md)

[Crossjoin](Crossjoin.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
