## Existing

EXISTING Operator.




### Description

The `EXISTING` operator allows to evaluate a set in the context of the current coordinates (e.g., slicer, sub-select, iteration, etc...). It performs an exist on the set following the `EXISTING` keyword using the current context (e.g. slicer); it works as a filter.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Slicer - set

</div>

<div class="ic3-mdx-example-body" style="display:none">

The set is evaluated taking into account the slicer definition.

In our example, [Cities] set is filtering all [Economy] countries using the slicer [Switzerland]

**Query**

```
WITH
    SET [Cities] AS EXISTING [Geography].[Economy].[Country].members
SELECT
    [Cities] ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Switzerland]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    SET [Cities] AS {[Geography].[Economy].[Switzerland]}
SELECT
    [Cities] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Slicer - calculated member

</div>

<div class="ic3-mdx-example-body" style="display:none">

The set is evaluated taking into account the slicer definition.

Our example is counting the number of cities for the country defined in the slicer (i.e., Switzerland).

**Query**

```
WITH MEMBER [City Count] AS Count( EXISTING [Geography].[Geo].[City].members )

SELECT
    [City Count] ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Switzerland]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">City Count</td>
</tr>
<tr>
 <td>3</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH MEMBER [City Count] AS Count( [Geography].[Geo].[Switzerland].children )

SELECT
    [City Count] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Sub-Select

</div>

<div class="ic3-mdx-example-body" style="display:none">

The set is evaluated taking into account the slicer definition.

Our example is counting the number of cities for the country defined in the sub-query (i.e., Switzerland).

**Query**

```
WITH MEMBER [City Count] AS Count( EXISTING [Geography].[Geo].[City].members )

SELECT
    [City Count] ON 0
FROM
    ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">City Count</td>
</tr>
<tr>
 <td>3</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH MEMBER [City Count] AS Count( [Geography].[Geo].[Switzerland].children )

SELECT
    [City Count] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

The set is evaluated taking into account the slicer definition.

Our example is counting the number of cities for the country defined in the axis (i.e., Switzerland).

**Query**

```
WITH MEMBER [City Count] AS Count( EXISTING [Geography].[Geo].[City].members )

SELECT
    [City Count] ON 0, [Geography].[Geo].[Switzerland] ON 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">City Count</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>3</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH MEMBER [City Count] AS Count( [Geography].[Geo].currentMember.children )

SELECT
    [City Count] ON 0, [Geography].[Geo].[Switzerland] ON 1
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Exists](Exists.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
