## ElementValue

Returns the value of an element of a VectorA or MatrixA.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|matrix/vector |expression |one | |
|tuple |tuple-expression |zero-one | |



### Return

```
numeric-value
```



### Description

This function returns the value of an element of a MatrixA or VectorA. The function can work
with index values for a Matrix or Vector or with a tuple value.

MatrixA().ElementValue() -> returns the element value using the current tuple to find for a matching element
MatrixA().ElementValue( ([United Kingdom], [2010]) ) -> returns the element value matching both members, null if no matching is found.

VectorA().ElementValue() -> returns the element value using the current tuple to find for a matching element ( get current member of the [Geography] hierarchy)
VectorA().ElementValue( [United Kingdom]) -> returns the element value matching the specified member, null if no matching is found.



### Since Version

4.8


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ElementValue() - Matrix

</div>

<div class="ic3-mdx-example-body" style="display:none">

ElementValue without parameters returns the cell defined by the current tuple.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] )
  MEMBER [Measures].[matrix-v] AS [matrix-a].ElementValue()
SELECT
  [Geography].[Geo].[Country] on 0,
  [Product].[Prod].[Licence] on 1
FROM
  [Sales]
 WHERE [matrix-v]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>768.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>144.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>96.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>4.0</td>
 <td>3.0</td>
 <td>8.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] )
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ElementValue(tuple) - Matrix

</div>

<div class="ic3-mdx-example-body" style="display:none">

ElementValue with a tuple as parameters returns the cell defined by the this tuple completed by the context.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] )
  MEMBER [Measures].[matrix-v] AS [matrix-a].ElementValue( ([Geography].[Geo].[Spain], [Product].[Prod].[Licence].[Personal]) )
SELECT
  [matrix-v] on 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">matrix-v</td>
</tr>
<tr>
 <td>3.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] )
  MEMBER [Measures].[matrix-v] AS [matrix-a].ElementValue()
SELECT
  ([Geography].[Geo].[Spain], [Product].[Prod].[Licence].[Personal]) on 0
FROM
  [Sales]
 WHERE [matrix-v]
```


**Assertion : Cell Equals**

```
WITH
  FUNCTION idx(set_, tuple_) AS  RANK(tuple_, set_) - 1
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] )
  MEMBER [Measures].[matrix-v] AS [matrix-a]->value( idx([Geography].[Geo].[Country],[Geography].[Geo].[Spain]), idx([Product].[Prod].[Licence],[Product].[Prod].[Licence].[Personal]) )
SELECT
  [matrix-v] on 0
FROM
  [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ElementValue(tuple) - Matrix Missing

</div>

<div class="ic3-mdx-example-body" style="display:none">

ElementValue with a tuple as parameters returns an empty cell if the Matrix or Vector element cannot be found. Note that a matrix is not a cube, for a matrix there is no hierarchical relation all members of a hierarchy are equal.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] )
  MEMBER [Measures].[matrix-v] AS [matrix-a].ElementValue( ([Geography].[Geo].[Madrid], [Product].[Prod].[Licence].[Personal]) )
SELECT
  [matrix-v] on 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">matrix-v</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[matrix-v] AS NULL
SELECT
  [matrix-v] on 0
FROM
  [Sales]
```


**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] )
  MEMBER [Measures].[matrix-v] AS [matrix-a].ElementValue( ([Geography].[Geo].[Spain].parent, [Product].[Prod].[Licence].[Personal]) )
SELECT
  [matrix-v] on 0
FROM
  [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ElementValue() - Vector

</div>

<div class="ic3-mdx-example-body" style="display:none">

ElementValue without parameters returns the cell defined by the current tuple.

**Query**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount] )
  MEMBER [Measures].[vector-v] AS [vector-a].ElementValue()
SELECT
  NON EMPTY [Geography].[Geo].[Country] on 0
FROM
  [Sales]
 WHERE [vector-v]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>0.0</td>
 <td>0.0</td>
 <td>768.0</td>
 <td>0.0</td>
 <td>4.0</td>
 <td>3.0</td>
 <td>248.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount] )
SELECT
  [Measures].[vector-a] on Axes
FROM
  [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ElementValue(tuple) - Vector

</div>

<div class="ic3-mdx-example-body" style="display:none">

ElementValue with a tuple as parameters returns the cell defined by the this tuple completed by the context.

**Query**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount] )
  MEMBER [Measures].[vector-v] AS [vector-a].ElementValue( [Geography].[Geo].[Spain] )
SELECT
  [vector-v] on 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">vector-v</td>
</tr>
<tr>
 <td>3.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount] )
  MEMBER [Measures].[vector-v] AS [vector-a].ElementValue()
SELECT
  ([Geography].[Geo].[Spain]) on 0
FROM
  [Sales]
 WHERE [vector-v]
```


**Assertion : Cell Equals**

```
WITH
  FUNCTION idx(set_, tuple_) AS  RANK(tuple_, set_) - 1
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount], INCLUDEEMPTY )
  MEMBER [Measures].[vector-v] AS [vector-a]->value( idx([Geography].[Geo].[Country],[Geography].[Geo].[Spain]) )
SELECT
  [vector-v] on 0
FROM
  [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ElementValue(tuple) - Vector Missing

</div>

<div class="ic3-mdx-example-body" style="display:none">

ElementValue with a tuple as parameters returns an empty cell if the Matrix or Vector element cannot be found. Note that a Vector is not a cube, for a Vector there is no hierarchical relation all members of a hierarchy are equal.

**Query**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount] )
  MEMBER [Measures].[vector-v] AS [vector-a].ElementValue( [Geography].[Geo].[Madrid] )
SELECT
  [vector-v] on 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">vector-v</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[vector-v] AS NULL
SELECT
  [vector-v] on 0
FROM
  [Sales]
```


**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[vector-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount] )
  MEMBER [Measures].[vector-v] AS [vector-a].ElementValue( [Geography].[Geo].[Spain].parent )
SELECT
  [vector-v] on 0
FROM
  [Sales]
```


 
</div>

                                                                                                            

### See Also


[MatrixA](MatrixA.md)

[VectorA](VectorA.md)

[SetAxes](SetAxes.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
