## DrilldownLevelTop

Drills down members from the specified set for the specified level expression. Only specified count of members from the bottom of the set will be appended to the result.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression | | |
|count |numeric-expression | | |
|level |level-expression |zero-one | |
|measure |numeric-expression |zero-one | |



### Return

```
set
```



### Description

This function drills down members from the specified set one level below. Only count members from the top (that have the highest value for the specified measure) will be appended to the result set.

If the level is specified only members from the set with this level will be drilled down.

If the measure parameter is specified it will be evaluated to order the members; if not specified the default measure will be used.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Level - measure

</div>

<div class="ic3-mdx-example-body" style="display:none">

We drill down a level for the [Spain] and [France] members and use the [Measures].[Amount] to order the top two members. In result we have hierarchized members [Spain] and [France] with two (top-sales) cities.

**Query**

```
DrilldownLevelTop({[Geography].[Geo].[Spain],[Geography].[Geo].[France]}, 2, [Geography].[Geo].[Country] ,[Measures].[Amount])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Paris]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{
[Geography].[Geo].[Spain],
Head(Order([Geography].[Geo].[Spain].children,[Measures].[Amount],BDESC),2),
[Geography].[Geo].[France],
Head(Order([Geography].[Geo].[France].children,[Measures].[Amount],BDESC),2)
}
```


**Assertion : MDX Equals**

```
// the [Measures].[Amount] coming from the current context
DrilldownLevelTop({[Geography].[Geo].[Spain],[Geography].[Geo].[France]}, 2, [Geography].[Geo].[Country] )
```


**Assertion : MDX Equals**

```
DrilldownLevelTop({[Geography].[Geo].[Spain],[Geography].[Geo].[France]},2,,[Measures].[Amount])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Level - no member/hierarchy available

</div>

<div class="ic3-mdx-example-body" style="display:none">

There is no member at the specified level in the set; so no drilldown is performed and the set itself is returned.

**Query**

```
DrilldownLevelTop( { [Geography].[Geo].[Europe], [Geography].[Geo].[Spain] }, 2, [Geography].[Geo].[City], [Measures].[Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Country].[Spain]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Geography].[Geo].[Europe], [Geography].[Geo].[Spain] }
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Tuple set : no level

</div>

<div class="ic3-mdx-example-body" style="display:none">

We create a set of tuples from European countries and [2010] year. We drill down for the countries (i.e., the first hierarchy is defaulted).

**Query**

```
DrilldownLevelTop( { ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Year].[2010] ) },3, , [Measures].[Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Country].[France], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Country].[Spain], [Time].[Calendar].[Year].[2010] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Union(
    { ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Year].[2010] ) },
    Head( Order( CrossJoin( [Geography].[Geo].[Continent].[Europe].children, [Time].[Calendar].[Year].[2010] ), [Measures].[Amount], BDESC ), 3 )
)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count : 0

</div>

<div class="ic3-mdx-example-body" style="display:none">

We pass 0 as the count parameter : no drilldown.

**Query**

```
DrilldownLevelTop( { [Geography].[Geo].[Europe] },0)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Geography].[Geo].[Europe] }
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Invalid level expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

There is no member from hierarchy of the specified level expression.

**Query**

```
DrilldownLevelTop( { [Geography].[Geo].[Europe], [Geography].[Geo].[Spain] },2, [Time].[Calendar].[Year] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DRILLDOWN_INVALID_HIERARCHY](icCubeError.md#olap_drilldown_invalid_hierarchy)</td></tr><tr><td>Error Message</td><td>

DrilldownLevelTop() : the hierarchy '[Time].[Calendar]' is not available in the set</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Null / empty set

</div>

<div class="ic3-mdx-example-body" style="display:none">

We pass a null/empty set and expect an empty set as result.

**Query**

```
{}
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
DrilldownLevelTop({},2)
```


**Assertion : MDX Equals**

```
DrilldownLevelTop(NULL,2)
```


 
</div>

                                                                         

### See Also


[DrilldownLevel](DrilldownLevel.md)

[DrilldownLevelBottom](DrilldownLevelBottom.md)

[DrilldownMember](DrilldownMember.md)

[DrilldownMemberBottom](DrilldownMemberBottom.md)

[DrilldownMemberTop](DrilldownMemberTop.md)

[DrillUpLevel](DrillUpLevel.md)

[DrillUpMember](DrillUpMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
