## DrillUpMember

Returns the members in a specified set that are not descendants of the members in the second specified set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set-1 |set-expression | | |
|set-2 |set-expression | | |



### Return

```
set
```



### Description

The DrillupMember function returns a set of members based on the members specified in the first set that are descendants of members in the second set.

A member will get drilled up only if it is 'immediately' followed by a child or a descendant.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Member set 

</div>

<div class="ic3-mdx-example-body" style="display:none">

We're drilling up all the countries of [Europe]. As the first set is Europeans countries and their cities (ordered in the natural hierarchy order), the result is the set of Europeans countries.

**Query**

```
DrillupMember(
    Hierarchize( Union (
        Descendants( [Geography].[Geo].[Europe], [Geography].[Geo].[Country], SELF ),
        Descendants( [Geography].[Geo].[Europe], [Geography].[Geo].[City], SELF )
    )),
    [Geography].[Geo].[Europe].children
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Europe].children
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Member set : parent-child specified

</div>

<div class="ic3-mdx-example-body" style="display:none">

We're drilling up the country [France]; as [Spain] is not following by its children its is not returned.

**Query**

```
DrillupMember(
    {
        [Geography].[Geo].[Spain],
        [Geography].[Geo].[France],
        [Geography].[Geo].[France].[Paris],
        [Geography].[Geo].[Spain].[Madrid]
    },
    {
        [Geography].[Geo].[France],
        [Geography].[Geo].[Spain]
    }
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Madrid]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{
    [Geography].[Geo].[Spain],
    [Geography].[Geo].[France],
    [Geography].[Geo].[Spain].[Madrid]
}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrillupMember({},member-set), DrillupMember(NULL,member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

We pass a null/empty set and expect an empty set as result.

**Query**

```
{}
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
DrillupMember( {}, { [Geography].[Geo].[Europe] } )
```


**Assertion : MDX Equals**

```
DrillupMember( NULL, { [Geography].[Geo].[Europe] } )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrillupMember(member-set,{}), DrillupMember(member-set,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

No drillup is performed : the first set is returned.

**Query**

```
{ [Geography].[Geo].[Europe],[Geography].[Geo].[America] }
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
DrillupMember( { [Geography].[Geo].[Europe], [Geography].[Geo].[America] }, {} )
```


**Assertion : MDX Equals**

```
DrillupMember( { [Geography].[Geo].[Europe], [Geography].[Geo].[America]}, NULL )
```


 
</div>

                                                                         

### See Also


[DrilldownLevel](DrilldownLevel.md)

[DrilldownLevelBottom](DrilldownLevelBottom.md)

[DrilldownLevelTop](DrilldownLevelTop.md)

[DrilldownMember](DrilldownMember.md)

[DrilldownMemberBottom](DrilldownMemberBottom.md)

[DrilldownMemberTop](DrilldownMemberTop.md)

[DrillUpLevel](DrillUpLevel.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
