## DrillUpLevel

Drills up all members from the specified set that are below the specified level.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression | | |
|level |level-numeric-expression |zero-one | |



### Return

```
set
```



### Description

The function drills up all members from the specified set that are above the specified Level.

If level is not specified then the level above the lowest level of the members in the set will be used for drill up.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrillUpLevel(member-set,level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

We have a set with European countries and all cities. Since we specified [Geography].[Geo].[Country] as drill up level, we will get only European countries in the result set.

**Query**

```
DrillUpLevel
(
    UNION([Geography].[Geo].[Europe].Children,[Geography].[Geo].[City].members),
    [Geography].[Geo].[Country]
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Europe].Children
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrillUpLevel(member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

The level parameter is optional for this function. If not specified the level above the lowest level of the set members will be injected implicitly. 
We have a set with [Europe], European countries and all cities. Since we didn't specify any level for drill up [Geography].[Geo].[Country] will be injected implicitly and we will get only European countries in the result set with [Europe] member itself.

**Query**

```
DrillUpLevel
(
    UNION([Geography].[Geo].[Europe],[Geography].[Geo].[Europe].Children,[Geography].[Geo].[City].members)
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Europe],[Geography].[Geo].[Europe].Children}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrillUpLevel(member-set) - members cannot be drilled up

</div>

<div class="ic3-mdx-example-body" style="display:none">

As the lowest level is the first level, there is no higher level available for drill up.

**Query**

```
DrillUpLevel( { [Time].[Calendar].[2010], [Time].[Calendar].[2011] } )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Year].[2010], 
  [Time].[Calendar].[Year].[2011]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Time].[Calendar].[2010], [Time].[Calendar].[2011] }
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrillUpLevel({},level), DrillUpLevel(NULL,level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

We pass null/empty set and expect an empty set as result.

**Query**

```
{}
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
DrillUpLevel(NULL,[Geography].[Geo].[City])
```


**Assertion : MDX Equals**

```
DrillUpLevel({},[Geography].[Geo].[City])
```


 
</div>

                                                                         

### See Also


[DrilldownLevel](DrilldownLevel.md)

[DrilldownLevelBottom](DrilldownLevelBottom.md)

[DrilldownLevelTop](DrilldownLevelTop.md)

[DrilldownMember](DrilldownMember.md)

[DrilldownMemberBottom](DrilldownMemberBottom.md)

[DrilldownMemberTop](DrilldownMemberTop.md)

[DrillUpMember](DrillUpMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
