## Divide

Performs a division returning the alternate value if the denominator is 0 or Empty


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|numerator |expression |one | |
|denominator |expression |one | |
|alternateresult |expression |zero-one |NULL |



### Return

```
value
```



### Description

The Divide function returns the division value ( numerator / denominator ). If the denominator is a
0, Empty or NULL value the function will return the alternate result.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Divide(2,3,33) - Basic example

</div>

<div class="ic3-mdx-example-body" style="display:none">

Divide function working as a standard division of the first two parameters

**Query**

```
Divide(2,3,33)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>0.6666666666666666</td></tr></table>


**Assertion : Cell Equals**

```
2/3
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Divide(2,0,33)- Alternate value

</div>

<div class="ic3-mdx-example-body" style="display:none">

The second parameter is 0, so the alternate value is returned. In our case 33.

            Note as in this scenario, the numerator is not evaluated (no error are generated).

**Query**

```
Divide(2,0,33)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>33</td></tr></table>


**Assertion : Cell Equals**

```
33
```


**Assertion : Cell Equals**

```
Divide(2,NULL,33)
```


**Assertion : Cell Equals**

```
Divide("I'm not evaluated",NULL,33)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Divide() - Example with tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

Divide function working as a standard division of the first two parameters

**Query**

```
Divide( ([Geography].[Geo].[Spain],[Measures].[Amount]), ([Geography].[Geo].[Europe],[Measures].[Amount]) , NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>0.011764705882352941</td></tr></table>


**Assertion : Cell Equals**

```
([Geography].[Geo].[Spain],[Measures].[Amount]).Value / ([Geography].[Geo].[Europe],[Measures].[Amount]).Value
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Divide(2,0)- without alternate value (default blank())

</div>

<div class="ic3-mdx-example-body" style="display:none">

The second parameter is 0, as no alternate value is defined a blank tuple is returned.

**Query**

```
Divide(2,0)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                                                            

### See Also


[Iif](Iif.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
