## DistinctCount

Returns the number of unique non empty elements in the specified set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |



### Return

```
numeric-value
```



### Description

Returns the number of unique elements in the specified set that are no empty.

It is equivalent to Count( Distinct(set), EXCLUDEEMPTY)



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DistinctCount(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the distinct number of members in the set.

In the example, the two distinct members [Paris] and [Madrid].

**Query**

```
WITH
    SET [Cities] AS {[Geography].[Geo].[Paris], [Geography].[Geo].[Madrid], [Geography].[Geo].[Paris]}
    MEMBER [Measures].[M. Count] AS DistinctCount( [Cities] * [Measures].[Amount] )
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">M. Count</td>
</tr>
<tr>
 <td>2</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    SET [Cities] AS {[Geography].[Geo].[Paris], [Geography].[Geo].[Madrid], [Geography].[Geo].[Paris]}
    MEMBER [Measures].[M. Count] AS Count( Distinct([Cities]) * [Measures].[Amount], EXCLUDEEMPTY)
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DistinctCount(set) - empty set

</div>

<div class="ic3-mdx-example-body" style="display:none">

The DistinctCount function evaluates the tuples of the set ignoring empty ones.

In the example, all cities without an [Amount] value are ignored.

**Query**

```
WITH
    MEMBER [Measures].[M. Count] AS DistinctCount( [Measures].[Amount] * [Geography].[Geo].[City].Members )
SELECT
    { [Measures].[M. Count] } ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">M. Count</td>
</tr>
<tr>
 <td>7</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[M. Count] AS Count( Distinct( [Measures].[Amount] * [Geography].[Geo].[City].Members) , EXCLUDEEMPTY)
SELECT
    { [Measures].[M. Count] } ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DistinctCount(set) - Measures current member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Like the Count function, DistinctCount uses the current member of the [Measures] when not specified.

Note that we are not using the [Measures] dimension for the calculated member using DistinctCount function.

**Query**

```
WITH
    MEMBER [Measures].[the-answer] AS 42, SOLVE_ORDER = 0
    MEMBER [Geography].[Geo].[City Count] AS DistinctCount( [Geography].[Geo].[City].Members ), SOLVE_ORDER = 10
SELECT
    { [Geography].[Geo].[City Count] } ON 0
FROM
    [Sales]
WHERE
    [Measures].[the-answer]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">City Count</td>
</tr>
<tr>
 <td>14</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Geography].[Geo].[City Count] AS Count( [Geography].[Geo].[City].Members )
SELECT
    { [Geography].[Geo].[City Count] } ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DistinctCount(set) - Recursive call

</div>

<div class="ic3-mdx-example-body" style="display:none">

As DistinctCount() is using the Measures current member (when not specified in the set tuples), you cannot define a calculated measure (as opposed to calculated member) without specifying explicitly the [Measures].

**Query**

```
WITH
    MEMBER [Measures].[City Count] AS DistinctCount( [Geography].[Geo].[City].Members )
SELECT
    [Measures].[City Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">City Count</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_CALC_MEMBER_STACK_OVERFLOW)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_CALC_MEMBER_STACK_OVERFLOW](icCubeError.md#olap_calc_member_stack_overflow)<br>Error Message : Calculated member [Measures].[City Count] stack overflow (see icCube.calcMemberMaxEvaluationFrameStackSize XMLA property) detected at (City Count City Count)</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DistinctCount(set) - NULL and empty set

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an 0 if applied to a NULL entity or empty set.

**Query**

```
WITH
    MEMBER [Measures].[M. Count] AS DistinctCount(NULL)
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">M. Count</td>
</tr>
<tr>
 <td>0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[M. Count] AS DistinctCount({})
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[M. Count] AS 0
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Count](Count.md)

[NonEmpty](NonEmpty.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
