## Dimension

Returns the hierarchy of a member,level or hierarchy.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |hierarchy-level-member-expression |one | |



### Return

```
hierarchy
```



### Description

Returns the hierarchy of a member,level or hierarchy entity.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension( member )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the hierarchy of the [Spain] member : [Geography].[Geo].

**Query**

```
WITH MEMBER [hierarchy-name] AS [Geography].[Geo].[Spain].dimension.uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">hierarchy-name</td>
</tr>
<tr>
 <td>[Geography].[Geo]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH MEMBER [hierarchy-name] AS [Geography].[Geo].uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension( level )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the hierarchy of the [Country] level : [Geography].[Geo].

**Query**

```
WITH MEMBER [hierarchy-name] AS [Geography].[Geo].[Country].dimension.uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">hierarchy-name</td>
</tr>
<tr>
 <td>[Geography].[Geo]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH MEMBER [hierarchy-name] AS [Geography].[Geo].uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimension( hierarchy )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the hierarchy itself : [Geography].[Geo].

**Query**

```
WITH MEMBER [hierarchy-name] AS [Geography].[Geo].dimension.uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">hierarchy-name</td>
</tr>
<tr>
 <td>[Geography].[Geo]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH MEMBER [hierarchy-name] AS [Geography].[Geo].uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[Hierarchy](Hierarchy.md)

[Level](Level.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
