## DefaultMember

Returns the default member of the specified dimension or hierarchy.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |dimension-hierarchy-expression |one | |



### Return

```
member
```



### Description

Returns the default member for the specified dimension or hierarchy.

If a query does not define a hierarchy, its default members will be used:

<pre> SELECT
[Geography].[Geo].[United States] ON 0
FROM
[Sales] </pre>

This is equivalent to:

<pre> SELECT
[Geography].[Geo].[United States] ON 0
FROM
[Sales]
WHERE
( [Geography].[Economy].defaultMember, [Time].[Calendar].defaultMember ... ) </pre>

It is recommended, and very common, to define a hierarchy default member as the All member of the hierarchy.

Not using All members, may result in unexpected results.

For example defining a default member as [Geography].[Economy].[Canada] would make our first query returning an empty result. Why? Because the tuple ([Geography].[Geo].[United States],[Geography].[Economy].[Canada]) does not exits and is an empty tuple by construction.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DefaultMember(Hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the default member of the [Time].[Calendar] hierarchy.

In our example the year [2010] is the default.

**Query**

```
[Time].[Calendar].DefaultMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Year].[2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Time].[Calendar].[2010]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DefaultMember(Dimension)

</div>

<div class="ic3-mdx-example-body" style="display:none">

The function can also be applied to dimensions with a unique hierarchy.

**Query**

```
[Measures].DefaultMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Measures].[Amount]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Measures].[Amount]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### null.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
NULL.DefaultMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

DefaultMember() : argument (0) type mismatch: expected:'hierarchy|dimension', got:'NULL'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tuple.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
([Geography].[Geo].[Spain],[Product].[Licence].[Personal]).DefaultMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

DefaultMember() : argument (0) type mismatch: expected:'hierarchy|dimension', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### level.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
[Geography].[Geo].[Continent].DefaultMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

DefaultMember() : argument (0) type mismatch: expected:'hierarchy|dimension', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### memberSet.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}.DefaultMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

DefaultMember() : argument (0) type mismatch: expected:'hierarchy|dimension', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tupleSet.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}.DefaultMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

DefaultMember() : argument (0) type mismatch: expected:'hierarchy|dimension', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### string.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
"hello".DefaultMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

DefaultMember() : argument (0) type mismatch: expected:'hierarchy|dimension', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Define Default Member](Define%20Default%20Member.md)

[CurrentMember](CurrentMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
