## CurrentOrdinal

Returns the current tuple ordinal (i.e., 1-based position) of the set being iterated.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |



### Return

```
tuple
```



### Description

Returns the current tuple ordinal (i.e., 1-based position) of the set being iterated.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### as-named-set.CurrentOrdinal - member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to a named set (of members) being iterated as declared within a function parameter.

**Query**

```
WITH
    MEMBER [Measures].[Ordinals] AS Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } AS countries, countries.CurrentOrdinal, "-" )
SELECT
    [Measures].[Ordinals] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Ordinals</td>
</tr>
<tr>
 <td>1-2</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Ordinals] AS "1-2"
SELECT
    [Measures].[Ordinals] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.CurrentOrdinal - member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to a named set (of members) being iterated.

**Query**

```
WITH
    SET    [Countries] AS { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] }
    MEMBER [Measures].[Ordinals] AS Generate( [Countries], countries.CurrentOrdinal, "-" )
SELECT
    [Measures].[Ordinals] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Ordinals</td>
</tr>
<tr>
 <td>1-2</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Ordinals] AS "1-2"
SELECT
    [Measures].[Ordinals] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.CurrentOrdinal - tuple

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to a named set (of tuples) being iterated.

**Query**

```
WITH
    SET    [MySet] AS { ( [Geography].[Geo].[New York], [Product].[icCube] ) }
    MEMBER [Measures].[Ordinals] AS Generate( [MySet], MySet.CurrentOrdinal, "-" )
SELECT
    [Measures].[Ordinals] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Ordinals</td>
</tr>
<tr>
 <td>1</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Ordinals] AS "1"
SELECT
    [Measures].[Ordinals] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Current](Current.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
