## Crossjoin

Returns the cross product of the specified sets.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one-n | |



### Return

```
set
```



### Description

Returns a list of tuples as a result of the cross product of the specified sets. For each combination a tuple is created as the sum of the tuple/items of the different sets.

{a,b,c} x {1,2} = {(a,1), (b,1), (c,1),(a,2), (b,2), (c,2)}

where {a,b,c} and {1,2} are members of two different hierarchies.

The sets have to be of different dimensionality (e.g. the crossjoin of members of the same hierarchy will return an error).

Please note that crossjoin does not produce non existing tuples into the resulting set. It also cares about the order of tuples in the resulting set (using the order of sets being cross-joined).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Crossjoin(set,set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Generates a cross product (i.e., all combinations) between two member sets.

**Query**

```
Crossjoin( [Time].[Calendar].[2010], {[Geography].[Geo].[America],[Geography].[Geo].[Europe]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Continent].[America] ), 
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Continent].[Europe] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ ([Time].[Calendar].[2010],[Geography].[Geo].[America]), ([Time].[Calendar].[2010],[Geography].[Geo].[Europe]) }
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Crossjoin(set,set) - Non existing tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

Crossjoin removes non existing tuples across hierarchies of the same dimension (performing an auto-exists).

In the example, we crossjoin all countries in [Geo] hierarchy with [Switzerland] from [Economy] hierarchy. The result is a single tuple with [Switzerland] in both hierarchies.

**Query**

```
Crossjoin( [Geography].[Geo].[Country].Members, [Geography].[Economy].[Country].[Switzerland])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Country].[Switzerland], [Geography].[Economy].[Country].[Switzerland] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].[Country].[Switzerland],[Geography].[Economy].[Country].[Switzerland])}
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Country].Members * {[Geography].[Economy].[Country].[Switzerland]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Crossjoin(set,set,set) - multiple sets

</div>

<div class="ic3-mdx-example-body" style="display:none">

The crossjoin function can be applied to more than two sets.

**Query**

```
Crossjoin( [Geography].[Geo].[Country].Members, [Geography].[Economy].[Country].[Switzerland], {[Time].[Calendar].[2010],[Time].[Calendar].[2011]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Country].[Switzerland], [Geography].[Economy].[Country].[Switzerland], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Geography].[Economy].[Country].[Switzerland], [Time].[Calendar].[Year].[2011] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Country].Members * {[Geography].[Economy].[Country].[Switzerland]} * {[Time].[Calendar].[2010],[Time].[Calendar].[2011]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Crossjoin(set,set) - with an empty set

</div>

<div class="ic3-mdx-example-body" style="display:none">

Crossjoin a set with an empty (or null) set will create an empty set.

**Query**

```
Crossjoin( [Geography].[Geo].[Country].Members, {} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Crossjoin( [Geography].[Geo].[Country].Members, NULL )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Crossjoin(set,set) - wrong dimensionality

</div>

<div class="ic3-mdx-example-body" style="display:none">

An error is returned if both sets share at least one hierarchy if icCube.xml option 'dimensionalityCheck' is set to true.

**Query**

```
Crossjoin( {[Time].[Calendar].[2010]}, {[Time].[Calendar].[2011]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_TUPLE_DIMENSIONALITY](icCubeError.md#olap_invalid_tuple_dimensionality)</td></tr><tr><td>Error Message</td><td>

invalid tuple dimensionality '[Time].[Calendar],[Time].[Calendar]' - ''</td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Crossjoin(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Crossjoin of a single set generates an error.

**Query**

```
Crossjoin( [Geography].[Geo].[Country].Members )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_UNEXPECTED_SET_COUNT](icCubeError.md#olap_unexpected_set_count)</td></tr><tr><td>Error Message</td><td>

Crossjoin() : the function is expecting at least two sets</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Crossjoin(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Crossjoin("hello", {})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Crossjoin() : argument (0) type mismatch: expected:'set', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[UpperCrossjoin](UpperCrossjoin.md)

[Extract](Extract.md)

[Except](Except.md)

[Intersect](Intersect.md)

[Union](Union.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
