## CovarianceN

Returns the covariance between two sets of data


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |numeric-expression |one | |
| |numeric-expression |one | |



### Return

```
numeric-value
```



### Description

Returns the unbiased population formula, covariance 1/N, between two sets of data ([Wikipedia](http://en.wikipedia.org/wiki/Covariance))



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Covariance

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the covariance of two data sets.

**Query**

```
CovarianceN( [Geography].[Geo].[Europe].children, [Amount], [Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>13284.666666666666</td></tr></table>


**Assertion : MDX Equals**

```
Covariance( [Geography].[Geo].[Europe].children, [Amount], [Amount] ) / ( [Geography].[Geo].[Europe].children.count / ([Geography].[Geo].[Europe].children.count-1) )
```


 
</div>

                                                                                                            

### See Also


[CovarianceN](CovarianceN.md)

[Stddev](Stddev.md)

[StddevP](StddevP.md)

[Correlation](Correlation.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
