## Cousin

Returns the descendant of the specified ancestor that is at the same level and relative position in the hierarchy as the specified member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
|ancestor |member-expression |one | |



### Return

```
member
```



### Description

The cousin function is based on position of members within levels.

It returns a descendant of the specified ancestor. This descendant has the same relative position within the specified ancestor as the specified member within its own ancestor (at the level of the specified ancestor).

Special care should be taken with this function as it's very easy to switch both members and getting a unexpected result (NULL).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Cousin(member,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

The cousin of the month [Feb 2010] in the year [2011] is the second (same relative position within the year level) months of the year [2011] : [Feb 2011].

**Query**

```
Cousin( [Time].[Calendar].[Feb 2010], [Time].[Calendar].[2011] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Feb 2011]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Time].[Calendar].[Feb 2011]
```


**Assertion : MDX Equals**

```
Descendants( [Time].[Calendar].[2011], [Time].[Calendar].[Feb 2010].level, SELF )(1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Cousin(member,member) - same level

</div>

<div class="ic3-mdx-example-body" style="display:none">

If both the specified member and the specified ancestor are at the same level, the ancestor is returned (second parameter).

**Query**

```
Cousin( [Time].[Calendar].[Jan 2010], [Time].[Calendar].[Jan 2011] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2011]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Time].[Calendar].[Jan 2011]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Cousin(member,member) - ancestor is actually a descendant

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns null if the ancestors is actually a descendant.

In our example, we switch both parameter members. So the ancestor [Feb 2010] is now a descendant of [2011].

**Query**

```
Cousin( [Time].[Calendar].[2011], [Time].[Calendar].[Feb 2010] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Cousin(member,member) - different hierarchies

</div>

<div class="ic3-mdx-example-body" style="display:none">

Both the specified member and the ancestor must belong to the same hierarchy.

**Query**

```
Cousin( [Geography].[Geo].[Paris], [Geography].[Economy].[Switzerland] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DIFFERENT_HIERARCHIES](icCubeError.md#olap_different_hierarchies)</td></tr><tr><td>Error Message</td><td>

Cousin() : unexpected hierarchy (expected:'[Geography].[Geo]') (actual:'[Geography].[Economy]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Cousin(NULL,member), Cousin(member,NULL), Cousin(NULL,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

No cousin is available in the following cases and a NULL value is returned.

**Query**

```
Cousin( NULL, [Geography].[Geo].[France] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


**Assertion : MDX Equals**

```
Cousin( [Geography].[Geo].[Paris], NULL )
```


**Assertion : MDX Equals**

```
Cousin( NULL, NULL )
```


 
</div>

                                                                         

### See Also


[Ancestors](Ancestors.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
