## Count(Level)

Returns the number of items.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |level-type-expression |one | |



### Return

```
numeric-value
```



### Description

Depending on the type of the expression, returns:

1) if a level is specified, the number of members of this level

2) if a tuple is specified, the number of members of this tuple

expression.Count : an alternate syntax that is equivalent to Count( expression )



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the number of members in the specified level.

**Query**

```
WITH
    MEMBER [Measures].[M. Count] AS [Geography].[Geo].[City].Count
SELECT
    [MEASURES].[M. Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">M. Count</td>
</tr>
<tr>
 <td>14</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[M. Count] AS count( [Geography].[Geo].[City].members )
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the number of members of the specified tuple.

**Query**

```
WITH
    MEMBER [Measures].[M. Count] AS ( [Geography].[Geo].DefaultMember, [Geography].[Economy].DefaultMember, [Measures].DefaultMember ).Count
SELECT
    [MEASURES].[M. Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">M. Count</td>
</tr>
<tr>
 <td>3</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[M. Count] AS 3
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count(hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns 1 as the hierarchy is converted into a tuple with one member (default member).

**Query**

```
WITH
    MEMBER [Measures].[M. Count] AS [Geography].[Geo].Count
SELECT
    [MEASURES].[M. Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">M. Count</td>
</tr>
<tr>
 <td>1</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[M. Count] AS 1
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns 1 as the member is converted into a tuple.

**Query**

```
WITH
    MEMBER [Measures].[M. Count] AS [Geography].[Geo].[United States].Count
SELECT
    [MEASURES].[M. Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">M. Count</td>
</tr>
<tr>
 <td>1</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[M. Count] AS 1
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count(tuple) - Non Existing Tuple

</div>

<div class="ic3-mdx-example-body" style="display:none">

For non existing tuples, count returns 0.

**Query**

```
WITH
    MEMBER [Measures].[M. Count] AS ( [Geography].[Geo].[France], [Geography].[Economy].[Canada], [Measures].DefaultMember ).Count
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">M. Count</td>
</tr>
<tr>
 <td>0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[M. Count] AS 0
SELECT
    [Measures].[M. Count] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Count(Dimensions)](Count(Dimensions).md)

[Count(Levels)](Count(Levels).md)

[Count](Count.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
