## CoalesceNull

Returns the first non-null/no-empty-set entity from the parameters list.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |dimension-hierarchy-level-expression |one-n | |



### Return

```
any
```



### Description

The function returns the first non-null/no-empty-set entity among the list of parameters. The parameter
can be any olap entity, for example a member, tuple, dimension, hierarchy, scalar value...

Members and tuples are not evaluted as in the CoalesceEmpty function.



### Since Version

6.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CoalesceNull(NULL,{},scalar,...)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first non empty / no null entity from the parameters.

**Query**

```
WITH
    MEMBER [Measures].[P] AS CoalesceNull(null,{},2)
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">P</td>
</tr>
<tr>
 <td>2</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[P] AS 2
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CoalesceNull(NULL,{},set,...)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first non empty / no null entity from the parameters.

**Query**

```
WITH
    Function _period(Value _f) as IIF( _f = true, {}, {[Time].[Calendar].[Year].[2010]} )
    MEMBER [Measures].[P] AS SetToStr( CoalesceNull(null,_period(true),_period(false) ) )
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">P</td>
</tr>
<tr>
 <td>{[Time].[Calendar].[Year].&[2010]}</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[P] AS {[Time].[Calendar].[Year].[2010]}.setToStr()
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CoalesceNull(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if all parameters are NULL entities.

**Query**

```
WITH
    MEMBER [Measures].[P] AS IsEmpty( CoalesceNull(null) )
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">P</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[P] AS True
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CoalesceNull()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Generates an error if no parameter is specified.

**Query**

```
CoalesceNull()
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

CoalesceNull() : unexpected number of parameters '0' (expected:'2147483647,1')</td></tr></table>


 
</div>

                                                                         

### See Also


[CoalesceEmpty](CoalesceEmpty.md)

[Iif](Iif.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
