## Case

Conditionally return specific values from multiple comparisons.




### Description

There are two types of case statements:
<ul>
<li>A simple case statement that compares an expression to a set of simple expressions to return specific values. Similar to the switch/case of other languages.
<li>A searched case statement that evaluates a set of Boolean expressions to return specific values. Similar to a list of nested if/else of other languages.
</ul>



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Simple Case

</div>

<div class="ic3-mdx-example-body" style="display:none">

This illustrates the 'simple' case syntax. The [Measures].[Amount] value is compared to several conditions to determine a 'category' information : none, small and large.

**Query**

```
with
    member [Category] as case [Measures].[Amount]
      when 0 then 'none'
      when 3 then 'small'
      when 4 then 'small'
      else  'large'
    end

select [Category] on 0, [Geography].[Geo].[Country].members on 1 from [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Category</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>none</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>none</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>large</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>none</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>small</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>small</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>large</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Simple Case : all WHEN clauses are FALSE

</div>

<div class="ic3-mdx-example-body" style="display:none">

When all the WHEN clauses are evaluated to false and there's no ELSE clause, NULL is returned.

**Query**

```
WITH
    MEMBER [Measures].[case-value] AS
        CASE 42
            WHEN 0 THEN 'zero'
            WHEN 1 THEN 'one'
        END
SELECT
    [Measures].[case-value] ON 0,
    {[Geography].[Geo].defaultMember} ON 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">case-value</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
 <td></td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Search Case

</div>

<div class="ic3-mdx-example-body" style="display:none">

This illustrates the 'search' case syntax. Several conditional expressions are evaluated to determine a 'category' information : tiny, small and large.

**Query**

```
with
    member [Category] as case
      when [Measures].[Amount] > 10 then 'large'
      when [Measures].[Amount] >  3 then 'small'
      else  'tiny'
    end

select [Category] on 0, [Geography].[Geo].[Country].members on 1 from [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Category</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>tiny</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>tiny</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>large</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>tiny</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>small</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>tiny</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>large</td>
</tr>
</table>



 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
