## BottomSum

Returns an ascending sorted set which cumulative sum is greater or equal than the specified sum value.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|sum |numeric-expression |one | |
|measure |value-expression |one | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
set
```



### Description

Function sorts the set in the ascending order according to the specified measure and returns the minimum number of elements whose cumulative sum is more or equal to the specified value.

If 0 was specified as a value the member with the lowest value is returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomSum(set,sum,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an ascending sorted set which cumulative sum is more or equal than the specified 'sum' value.

In our example we return the first two members [1],[2] as their value is below the requested 2 of the total and with one member less it is not enough to reach 2.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    BottomSum( {[Geography].[Geo].[3],[Geography].[Geo].[2],[Geography].[Geo].[1]},2, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">1</td>
  <td class="ic3-mdx-result-cell-header">2</td>
</tr>
<tr>
 <td>1.0</td>
 <td>2.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
SELECT
   {[Geography].[Geo].[1],[Geography].[Geo].[2]} ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    // exact match
    BottomSum( {[Geography].[Geo].[3],[Geography].[Geo].[2],[Geography].[Geo].[1]},3, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomSum(set,sum,numeric) - empty values

</div>

<div class="ic3-mdx-example-body" style="display:none">

Members/Tuples of the set with empty values are included into the returned set. They count as 0 values.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[E]     AS NULL
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    BottomSum( {[Geography].[Geo].[E],[Geography].[Geo].[1],[Geography].[Geo].[2],[Geography].[Geo].[3]},2, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">E</td>
  <td class="ic3-mdx-result-cell-header">1</td>
  <td class="ic3-mdx-result-cell-header">2</td>
</tr>
<tr>
 <td></td>
 <td>1.0</td>
 <td>2.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[E]     AS NULL
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
SELECT
   {[Geography].[Geo].[E],[Geography].[Geo].[1],[Geography].[Geo].[2]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomSum(set,sum,numeric) - sum is too big

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the specified 'sum' value is not reached then all members will be returned, including empty cells.

In this case, the function behaves as the Order(set,numeric2,BASC) function.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    BottomSum( {[Geography].[Geo].[1],[Geography].[Geo].[2],[Geography].[Geo].[3]}, 100, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">1</td>
  <td class="ic3-mdx-result-cell-header">2</td>
  <td class="ic3-mdx-result-cell-header">3</td>
</tr>
<tr>
 <td>1.0</td>
 <td>2.0</td>
 <td>3.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    {[Geography].[Geo].[1],[Geography].[Geo].[2],[Geography].[Geo].[3]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomSum(set,sum,numeric) - sum is too small

</div>

<div class="ic3-mdx-example-body" style="display:none">

This function returns at least one member even if its value is higher than specified 'sum' value.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[2]     AS 2.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
SELECT
    BottomSum( {[Geography].[Geo].[1],[Geography].[Geo].[2],[Geography].[Geo].[3]}, 0.2, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">1</td>
</tr>
<tr>
 <td>1.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
SELECT
    {[Geography].[Geo].[1]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomSum(set,sum,numeric) - duplicated members

</div>

<div class="ic3-mdx-example-body" style="display:none">

BottomSum makes no difference with duplicated members. Our example is selecting twice the [Geography].[Geo].[1] calculated member.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1] AS 1
    MEMBER [Geography].[Geo].[2] AS 2
SELECT
    BottomSum( { [Geography].[Geo].[1], [Geography].[Geo].[2], [Geography].[Geo].[1] }, 2, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">1</td>
  <td class="ic3-mdx-result-cell-header">1</td>
</tr>
<tr>
 <td>1</td>
 <td>1</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[1] AS 1
SELECT
   { [Geography].[Geo].[1], [Geography].[Geo].[1] } ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomSum(set,sum,numeric) - negative sum

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if a negative 'sum' value is specified.

**Query**

```
BottomSum([Geography].[Geo].[City].Members, -1, [Measures].[Amount])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_OUT_OF_RANGE](icCubeError.md#olap_out_of_range)</td></tr><tr><td>Error Message</td><td>

BottomSum() : the sum value '-1.0' is out of range (expected range:'>= 0')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomSum(set,sum) - missing numeric expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if no numeric expression is specified.

**Query**

```
BottomSum([Geography].[Geo].[City].Members, 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

BottomSum() : unexpected number of parameters '2' (expected:'4,3')</td></tr></table>


 
</div>

                                                                         

### See Also


[TopSum](TopSum.md)

[BottomCount](BottomCount.md)

[TopCount](TopCount.md)

[BottomPercent](BottomPercent.md)

[TopPercent](TopPercent.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
