## BottomPercent

Returns a ascending sorted set which cumulative percent is greater or equal than the specified percent (i.e., a value between 0 and 100).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|percent |numeric-expression |one | |
|measure |value-expression |one | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
set
```



### Description

Function sorts the set in the ascending order according to the specified measure and returns the minimum number of elements whose cumulative percent is greater or equal to the specified percent.

If 0 was specified as a percent the member with the lowest value is returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomPercent(set,percent,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an ascending sorted set which cumulative percent is more or equal than the specified 'percent' value.

In our example we return the first two members [20],[30] as their value is below the requested 45% of the total and with one member less it is not enough to reach 55%.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
    BottomPercent( {[Geography].[Geo].[20],[Geography].[Geo].[30],[Geography].[Geo].[50]},45, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">20</td>
  <td class="ic3-mdx-result-cell-header">30</td>
</tr>
<tr>
 <td>20</td>
 <td>30</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
SELECT
    {[Geography].[Geo].[20],[Geography].[Geo].[30]} ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
    BottomPercent( {[Geography].[Geo].[20],[Geography].[Geo].[30],[Geography].[Geo].[50]},50, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomPercent(set,percent,numeric) - duplicated members

</div>

<div class="ic3-mdx-example-body" style="display:none">

BottomPercent makes no difference with duplicated members. Our example is selecting twice the [Geography].[Geo].[20] calculated member.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[20] AS 20
    MEMBER [Geography].[Geo].[30] AS 30
SELECT
    BottomPercent( { [Geography].[Geo].[20], [Geography].[Geo].[30], [Geography].[Geo].[20] }, 40, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">20</td>
  <td class="ic3-mdx-result-cell-header">20</td>
</tr>
<tr>
 <td>20</td>
 <td>20</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[20] AS 20
SELECT
    { [Geography].[Geo].[20], [Geography].[Geo].[20] } ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomPercent(set,percent,numeric) - percent > 100 and empty values

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the specified 'percent' value is greater or equal than 100% all members will be returned, including empty cells.

In this case, the function behaves as Order(set,numeric2,BASC) function.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[E]      AS NULL
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
    BottomPercent( {[Geography].[Geo].[E],[Geography].[Geo].[20],[Geography].[Geo].[30],[Geography].[Geo].[50]},150, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">E</td>
  <td class="ic3-mdx-result-cell-header">20</td>
  <td class="ic3-mdx-result-cell-header">30</td>
  <td class="ic3-mdx-result-cell-header">50</td>
</tr>
<tr>
 <td></td>
 <td>20</td>
 <td>30</td>
 <td>50</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[E]      AS NULL
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
     Order({[Geography].[Geo].[E],[Geography].[Geo].[20],[Geography].[Geo].[30],[Geography].[Geo].[50]}, [Measures].[Amount], BASC)  ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomPercent(set,percent,numeric) - percent equals 0

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the specified 'percent' value is equal to 0 the first element of the set is returned (lowest one).

**Query**

```
WITH
    MEMBER [Geography].[Geo].[E]      AS NULL
    MEMBER [Geography].[Geo].[20]     AS 20
    MEMBER [Geography].[Geo].[30]     AS 30
    MEMBER [Geography].[Geo].[50]     AS 50
SELECT
    BottomPercent( {[Geography].[Geo].[E],[Geography].[Geo].[20],[Geography].[Geo].[30],[Geography].[Geo].[50]},0, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">E</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[E] AS NULL
SELECT
     {[Geography].[Geo].[E]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomPercent(set,percent,numeric) - negative percent

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if a negative 'percent' value is used.

**Query**

```
BottomPercent([Geography].[Geo].[City].Members, -1, [Measures].[Amount])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_OUT_OF_RANGE](icCubeError.md#olap_out_of_range)</td></tr><tr><td>Error Message</td><td>

BottomPercent() : the percent value '-1.0' is out of range (expected range:'[0..1]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomPercent(set,percent)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if a negative 'percent' value is used.

**Query**

```
BottomPercent([Geography].[Geo].[City].Members, 20)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

BottomPercent() : unexpected number of parameters '2' (expected:'4,3')</td></tr></table>


 
</div>

                                                                         

### See Also


[TopPercent](TopPercent.md)

[BottomCount](BottomCount.md)

[TopCount](TopCount.md)

[BottomSum](BottomSum.md)

[TopSum](TopSum.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
