## BottomCount

Returns the lowest specified count of tuples. The numeric expression is used to evaluate the tuple value.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|count |numeric-expression |one | |
|measure |value-expression |zero-one |[Measures].currentMember |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
set
```



### Description

Returns the lowest specified count of tuples.

1) A measures expression is specified.

The tuples of the specified set are sorted in ascending order according to their cell values. Then, the specified number of tuples with the lowest values are returned. Note that empty cells are not ignored and are considered as zero values.

2) A measures expression is not specified.

The BottomCount(set,count,measure) function is then equivalent to the Head(Order(set,measure,BASC),count) function.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomCount(set,count,numeric) - set of members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the lowest 'count' members of the set. Members are evaluated using the 'numeric' expression.

In our example returns the 3 [Countries] with the lowest [Amount].

**Query**

```
BottomCount( NonEmpty( [Geography].[Geo].[Country].Members ), 3, [Measures].[Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Head( Order( NonEmpty( [Geography].[Geo].[Country].Members ), [Measures].[Amount], BASC), 3)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomCount(set,count,numeric) - set of tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the lowest 'count' tuples of the set. Tuples are evaluated using the 'numeric' expression.

In our example returns the 3 [Countries] for [2010] with the lowest [Amount].

**Query**

```
BottomCount( NonEmpty( [Time].[Calendar].[2010] * [Geography].[Geo].[Country].Members ), 3, [Measures].[Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Country].[Spain] ), 
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Country].[France] ), 
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Country].[Switzerland] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Head( Order( NonEmpty( [Time].[Calendar].[2010] * [Geography].[Geo].[Country].Members ), [Measures].[Amount], BASC), 3)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomCount(set,count) same as Tail(set,count)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Without any numeric expression specified, the BottomCount function is equivalent to the Tail function.

**Query**

```
BottomCount( [Geography].[Geo].[Country].Members, 3)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Tail( [Geography].[Geo].[Country].Members, 3 )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomCount(member-set,numeric,measure, EXCLUDEEMPTY) - exclude empty cells

</div>

<div class="ic3-mdx-example-body" style="display:none">

Tuples/Members with empty cells can be excluded in BottomCount with the EXCLUDEEMPTY flag.

**Query**

```
SELECT
    BottomCount( [Geography].[Geo].[Country].Members, 3, [Measures].[Amount], EXCLUDEEMPTY ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>3</td>
 <td>4</td>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
   Head( Order( Filter( [Geography].[Geo].[Country].Members, IsEmpty( [Measures].[Amount] ) = FALSE ),[Measures].[Amount], ASC), 3)  ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomCount(set,count,numeric) - empty cells

</div>

<div class="ic3-mdx-example-body" style="display:none">

Tuples/Members with empty cells are included in BottomCount, they are considered as zero values.

In order to check this behavior we will add a little complication :

[count +] : should return 0 as two empty countries are the lowest ones ([Amount] is positive)
[count -] : should return 2 as negative values are lower than empty ones.

**Query**

```
WITH
    SET [Countries +] AS BottomCount( [Geography].[Geo].[Country].Members, 2, [Measures].[Amount] )
    SET [Countries -] AS BottomCount( [Geography].[Geo].[Country].Members, 2, -[Measures].[Amount] )
    MEMBER [count +] AS count([Countries +] * [Measures].[Amount] , EXCLUDEEMPTY)
    MEMBER [count -] AS count([Countries -] * [Measures].[Amount] , EXCLUDEEMPTY)
SELECT
   {[Measures].[count +],[Measures].[count -]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">count +</td>
  <td class="ic3-mdx-result-cell-header">count -</td>
</tr>
<tr>
 <td>0</td>
 <td>2</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [count +] AS 0
    MEMBER [count -] AS 2
SELECT
   {[Measures].[count +],[Measures].[count -]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomCount(set,count,numeric) - set of duplicated members

</div>

<div class="ic3-mdx-example-body" style="display:none">

BottomCount makes no difference with duplicated members. Our example is selecting twice the [Country] with the lowest [Amount].

**Query**

```
BottomCount( NonEmpty( Union( [Geography].[Geo].[Country].Members, [Geography].[Geo].[Country].Members, ALL )), 2, [Measures].[Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Spain]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{
BottomCount( NonEmpty( [Geography].[Geo].[Country].Members ), 1, [Measures].[Amount] ),
BottomCount( NonEmpty( [Geography].[Geo].[Country].Members ), 1, [Measures].[Amount] )
}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### BottomCount(NULL,numeric),BottomCount({},numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applying the function to NULL produces the same result as for an empty set.

**Query**

```
BottomCount(NULL, 2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
BottomCount({},2)
```


 
</div>

                                                                         

### See Also


[TopCount](TopCount.md)

[DrilldownMemberBottom](DrilldownMemberBottom.md)

[Tail](Tail.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
