## Axes

About the usage of axes in a `SELECT` statement.




### Description

This section highlights some notable usages of the axes of a `SELECT` statement (e.g., auto-exists, ...).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Non-Existing Tuples As an Axis Cross-Product

</div>

<div class="ic3-mdx-example-body" style="display:none">

Non-existing tuples are not removed from an axis cross-product.

In our example, even though only the tuple ([Geography].[Geo].[France], [Geography].[Economy].[France] )
exists, all other countries are shown in the result.

**Query**

```
SELECT
    { [Geography].[Economy].[Country].members } on 0,
    { [Geography].[Geo].[France] } on 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
</tr>
</table>



 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
