## AllMembers

Returns all members of a specified level, hierarchy or dimension including their calculated members.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |dimension-hierarchy-level-expression |one | |



### Return

```
set
```



### Description

AllMembers returns all members including calculated members.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### [Measures].AllMembers

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all members including calculated ones of [Measures] dimension.

**Query**

```
WITH
    MEMBER [Measures].[V] AS 42
SELECT
    [Measures].AllMembers ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
  <td class="ic3-mdx-result-cell-header">Amount-Min</td>
  <td class="ic3-mdx-result-cell-header">Amount-Max</td>
  <td class="ic3-mdx-result-cell-header">Amount-Count</td>
  <td class="ic3-mdx-result-cell-header">Amount-AvgChildren</td>
  <td class="ic3-mdx-result-cell-header">Amount-None</td>
  <td class="ic3-mdx-result-cell-header">Amount-Open</td>
  <td class="ic3-mdx-result-cell-header">Amount-Close</td>
  <td class="ic3-mdx-result-cell-header">Amount-OpenNoEmpty</td>
  <td class="ic3-mdx-result-cell-header">Amount-CloseNoEmpty</td>
  <td class="ic3-mdx-result-cell-header">Amount-AvgLeaves</td>
  <td class="ic3-mdx-result-cell-header">Amount-NoEmpty</td>
  <td class="ic3-mdx-result-cell-header">Amount-Unique</td>
  <td class="ic3-mdx-result-cell-header">Fx</td>
  <td class="ic3-mdx-result-cell-header">Answer</td>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>1023</td>
 <td>1.00€</td>
 <td>512.00€</td>
 <td>10</td>
 <td>102.3</td>
 <td></td>
 <td></td>
 <td></td>
 <td>1</td>
 <td>512</td>
 <td>102.3</td>
 <td>1</td>
 <td>10</td>
 <td>1.0310000000000001</td>
 <td>42</td>
 <td>42</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
   MEMBER [Measures].[V] AS 42
SELECT
   Union( [Measures].Members, [Measures].[Answer] /* defined at cube level */ , [Measures].[V] ) ON 0
FROM
   [Sales]
```


**Assertion : MDX Equals**

```
WITH
   MEMBER [Measures].[V] AS 42
SELECT
   AddCalculatedMembers( [Measures].Members ) ON 0
FROM
   [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### level.AllMembers

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all members of the level including calculated members.

In our example all cities including [Basel].

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Neverland] AS 41
    MEMBER [Geography].[Geo].[Switzerland].[Basel] AS 42
SELECT
    [Geography].[Geo].[City].AllMembers ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Quebec</td>
  <td class="ic3-mdx-result-cell-header">Toronto</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">Los Angeles</td>
  <td class="ic3-mdx-result-cell-header">New York</td>
  <td class="ic3-mdx-result-cell-header">San Francisco</td>
  <td class="ic3-mdx-result-cell-header">Caracas</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Geneva</td>
  <td class="ic3-mdx-result-cell-header">Lausanne</td>
  <td class="ic3-mdx-result-cell-header">Zurich</td>
  <td class="ic3-mdx-result-cell-header">Basel</td>
</tr>
<tr>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>768</td>
 <td></td>
 <td></td>
 <td>4</td>
 <td>2</td>
 <td>1</td>
 <td></td>
 <td>128</td>
 <td>56</td>
 <td>64</td>
 <td>42</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[Switzerland].[Basel] AS 42
SELECT
    Hierarchize( Union( [Geography].[Geo].[City].members, [Geography].[Geo].[Switzerland].[Basel] ))  ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[Switzerland].[Basel] AS 42
SELECT
    Hierarchize( AddCalculatedMembers( [Geography].[Geo].[City].members ))  ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.AllMembers

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all members of the hierarchy including calculated members.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Switzerland].[Basel] AS 42
SELECT
    [Geography].[Geo].AllMembers ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">All Regions</td>
  <td class="ic3-mdx-result-cell-header">America</td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Quebec</td>
  <td class="ic3-mdx-result-cell-header">Toronto</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Los Angeles</td>
  <td class="ic3-mdx-result-cell-header">New York</td>
  <td class="ic3-mdx-result-cell-header">San Francisco</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">Caracas</td>
  <td class="ic3-mdx-result-cell-header">Europe</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
  <td class="ic3-mdx-result-cell-header">Geneva</td>
  <td class="ic3-mdx-result-cell-header">Lausanne</td>
  <td class="ic3-mdx-result-cell-header">Zurich</td>
  <td class="ic3-mdx-result-cell-header">Basel</td>
</tr>
<tr>
 <td>1023</td>
 <td>768</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>768</td>
 <td></td>
 <td>768</td>
 <td></td>
 <td></td>
 <td></td>
 <td>255</td>
 <td>4</td>
 <td>4</td>
 <td>3</td>
 <td>2</td>
 <td>1</td>
 <td></td>
 <td>248</td>
 <td>128</td>
 <td>56</td>
 <td>64</td>
 <td>42</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
   MEMBER [Geography].[Geo].[Switzerland].[Basel] AS 42
SELECT
   Hierarchize( Union( [Geography].[Geo].members, [Geography].[Geo].[Switzerland].[Basel] ))  ON 0
FROM
   [Sales]
```


**Assertion : MDX Equals**

```
WITH
   MEMBER [Geography].[Geo].[Switzerland].[Basel] AS 42
SELECT
   Hierarchize( AddCalculatedMembers( [Geography].[Geo].members ))  ON 0
FROM
   [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NULL.AllMembers

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if AllMember is applied to a NULL entity.

**Query**

```
NULL.AllMembers
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

AllMembers() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'NULL'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tuple.AllMembers

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
([Geography].[Geo].[Spain],[Product].[Licence].[Personal]).AllMembers
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

AllMembers() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### memberSet.AllMembers

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}.AllMembers
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

AllMembers() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tupleSet.AllMembers

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}.AllMembers
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

AllMembers() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### string.AllMembers

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
"hello".AllMembers
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

AllMembers() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Members](Members.md)

[AddCalculatedMembers](AddCalculatedMembers.md)

[StripCalculatedMembers](StripCalculatedMembers.md)

[Calculated Members](Calculated%20Members.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
